% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/simulation.r
\name{sim}
\alias{sim}
\title{Simulate from DAG or list of DAGs (Either Action or Observed DAG(s))}
\usage{
sim(DAG, actions, n, wide = TRUE, LTCF = NULL, rndseed = NULL)
}
\arguments{
\item{DAG}{A DAG objects that has been locked with set.DAG(DAG). Observed data from this DAG will be simulated if actions argument is omitted.}

\item{actions}{Character vector of action names which will be extracted from the DAG object. Alternatively, this can be a list of action DAGs selected with \code{A(DAG)} function, in which case the argument \code{DAG} is unused. When this argument is missing, the default is to samlpe observed data from the \code{DAG} object.}

\item{n}{Number of observations to sample.}

\item{wide}{A logical, if TRUE the output data is generated in wide format, if FALSE, the output longitudinal data in generated in long format}

\item{LTCF}{The name of the right-censoring / failure event indicator variable for the Last Time-point Carried Forward imputation. By default, when LTCF is left unspecified, all variables that follow after any end of follow-up (EFU) event are set to missing (NA). The end of follow-up event occurs when a binary node declared with EFU=TRUE is observed to be equal to 1, indicating a failing or right-censoring event. To forward impute the values of the time-varying nodes after the occurrence of the EFU event, set the LTCF argument to a name of the EFU node representing this event. This implies that for each observation, missing value of a time-varying variable (that is node declared with t argument) will be replaced by the last observed value of that variable, if the missingness is a result of the EFU event of the node LTCF.}

\item{rndseed}{Seed for the random number generator.}
}
\value{
If actions argument is missing a simulated data.frame is returned, otherwise the function returns a named list of action-specific simulated data.frames with action names giving names to corresponding list items.
}
\description{
This function simulates full data based on a list of intervention DAGs, returning a list of \code{data.frames}
}

