\name{mc.matrix}
\Rdversion{1.1}
\alias{build.mc.matrix}
\alias{check.mc.matrix}

\title{Build and check misclassification matrices from empirical estimations}

\description{
  Empirical misclassification matrices to the power of lambda may not exist for
  small values of lambda. These functions provide methods to estimate the nearest
  version of the misclassification matrix that satisfies the conditions a
  misclassification matrix has to fulfill, and to check it (existance for exponents
  smaller than 1).
}

\usage{
build.mc.matrix(mc.matrix, method = "series", tuning = sqrt(.Machine$double.eps),
  diag.cor = FALSE, tol = .Machine$double.eps, max.iter = 100)
check.mc.matrix(mc.matrix, tol = .Machine$double.eps)
}

\arguments{
  \item{mc.matrix}{an empirical misclassification matrix}
  \item{method}{method used to estimate the generator for the misclassification
    matrix (see Details)}
  \item{tuning}{security parameter for numerical reasons}
  \item{diag.cor}{should corrections be substracted from the diagonal or from all
    values corresponding to the size?}
  \item{tol}{tolerance level for series method for convegence}
  \item{max.iter}{maximal number of iterations for the serie method to converge}
}

\details{
  Method "series" constructs a generator via the series

\eqn{(Pi-I) - (Pi-I)^2/2 + (Pi-I)^3/3 - \dots}

  Method "log" constructs the generator via taking the log of the
  misclassification matrix.

  Small negative off-diagonal values are corrected and set to (0 + tuning).

  The amount used to correct for negative values is added to the diagonal element
  if \code{diag.cor = TRUE} and distributed among all values if
  \code{diag.cor = FALSE}.

  Method "jlt" uses the method described by Jarro et al. (see Israel et al.).
}

\value{
  \code{build.mc.matrix()} returns a misclassification matrix that is the closest
  estimate for a working misclassification matrix.

  \code{check.mc.matrix()} returns a vector of logicals.
}

\references{
Israel, R.B., Rosenthal, J.S., Wei, J.Z., Finding generators for Markov Chains
  via empirical transition matrices, with applications to credit ratings,
  \emph{Mathematical Finance}, \bold{11}, 245--265}

\author{ Wolfgang Lederer, \email{wolfgang.lederer@gmail.com}}

\note{Does not always work! So check properly.}

\seealso{\code{\link[simex]{mcsimex}}, \code{\link[simex]{misclass}}, \code{\link[simex]{diag.block}}}

\examples{
Pi <- matrix(data = c(0.989, 0.01, 0.001, 0.17, 0.829, 0.001, 0.001, 0.18, 0.819),
    nrow = 3, byrow = FALSE)
check.mc.matrix(list(Pi))
check.mc.matrix(list(build.mc.matrix(Pi)))
build.mc.matrix(Pi)

Pi3 <- matrix(c(0.8, 0.2, 0, 0, 0, 0.8, 0.1, 0.1, 0, 0.1, 0.8, 0.1, 0, 0, 0.3, 0.7),
    nrow = 4)
check.mc.matrix(list(Pi3))
build.mc.matrix(Pi3)
check.mc.matrix(list(build.mc.matrix(Pi3)))

P1 <- matrix(c(1, 0, 0, 1), nrow = 2)
P2 <- matrix(c(0.8, 0.15, 0, 0.2, 0.7, 0.2, 0, 0.15, 0.8), nrow = 3, byrow = TRUE)
P3 <- matrix(c(0.4, 0.6, 0.6, 0.4), nrow = 2)
mc.matrix <- list(P1, P2, P3)
check.mc.matrix(mc.matrix) # TRUE FALSE FALSE
}

\keyword{regression}
