% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_simulation_landscape.R
\name{make_2d_kernel_dist}
\alias{make_2d_kernel_dist}
\title{Make 2D kernel smooth distribution}
\usage{
make_2d_kernel_dist(
  output,
  x,
  y,
  n = 200,
  lims = c(-0.1, 1.1, -0.1, 1.1),
  h,
  kde_fun = "ks"
)
}
\arguments{
\item{output}{A matrix of simulation output.}

\item{x, y}{The name of the target variable.}

\item{n, lims, h}{Passed to \code{\link[ks]{kde}} or \code{\link[MASS]{kde2d}}.
If using \code{ks::kde}, \code{H = diag(h, 2, 2)}.
Note: the definition of bandwidth (`h`) is different in two functions.
To get a similar output, the `h` is about 50 to 5000 times smaller for \code{\link[ks]{kde}} than \code{\link[MASS]{kde2d}}}

\item{kde_fun}{Which to use? Choices: "ks" \code{ks::kde} (default; faster and taking less memory); "MASS" \code{MASS::kde2d}.}
}
\value{
A \code{kde2d}-type list.
}
\description{
Make 2D kernel smooth distribution
}
