% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_simulation.R
\name{modified_simulation}
\alias{modified_simulation}
\alias{batch_simulation}
\title{Do the batch simulation}
\usage{
modified_simulation(sim_fun, var_list, default_list, bigmemory = TRUE, ...)

batch_simulation(var_grid, sim_fun, default_list, bigmemory = TRUE, ...)
}
\arguments{
\item{sim_fun}{The simulation function. See \code{\link{sim_fun_test}}
for an example.}

\item{var_list}{An \code{var_list} object generated by \code{\link{fill_in_struct}}.}

\item{default_list}{A list of default values for \code{sim_fun}.}

\item{bigmemory}{Use \code{\link{hash_big.matrix-class}} to store large matrices?}

\item{...}{Other parameters passed to \code{sim_fun}}

\item{var_grid}{A \code{var_grid} object. See \code{\link{make_var_grid}}.}
}
\value{
A \code{batch_simulation} object, also a data frame.
The first column, \code{var}, is a list of
\code{var_list} that contains all the variables; the second to the second
last columns are the values of the variables; the last column is the
output of the simulation function.
}
\description{
This is the main function for the batch simulation.
}
\section{Functions}{
\itemize{
\item \code{modified_simulation}: Modify a single simulation.
}}

\examples{
test <- new_var_set()
test <- test \%>\%
  add_var("par1", "var1", 1, 2, 0.1) \%>\%
  add_var("par2", "var2", 1, 2, 0.1)
test_grid <- make_var_grid(test)
test_result <- batch_simulation(test_grid, sim_fun_test,
  default_list = list(
    par1 = list(var1 = 0),
    par2 = list(var2 = 0, var3 = 0)
  ), bigmemory = FALSE
)
test_result
}
