% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_simulation.R
\name{new_arg_set}
\alias{new_arg_set}
\alias{add_arg_ele}
\title{Create and modify argument sets for batch simulation}
\usage{
new_arg_set()

add_arg_ele(arg_set, arg_name, ele_name, start, end, by)
}
\arguments{
\item{arg_set}{An \code{arg_set} object.}

\item{arg_name, ele_name}{The name of the argument and its element
in the simulation function}

\item{start, end, by}{The data points where you want to test the variables.
Passed to \code{seq}.}
}
\value{
An \code{arg_set} object.
}
\description{
An argument set contains the descriptions of the relevant variables in a
batch simulation. Use \code{new_arg_set} to create an \code{arg_set}
object, and use the \code{add} to add descriptions of arguments.
}
\section{Functions}{
\itemize{
\item \code{new_arg_set()}: Create an \code{arg_set}.

}}
\seealso{
\code{\link[=make_arg_grid]{make_arg_grid()}} for making grids from variable sets;
\code{\link[=batch_simulation]{batch_simulation()}} for running batch simulation and a
concrete example.
}
