% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{batch}
\alias{batch}
\alias{separate}
\title{Add a batch/separate activity}
\usage{
batch(traj, n, timeout = 0, permanent = FALSE, name = "", rule = NULL)

separate(traj)
}
\arguments{
\item{traj}{the trajectory object.}

\item{n}{batch size, accepts a numeric.}

\item{timeout}{set an optional timer which triggers batches every \code{timeout} time
units even if the batch size has not been fulfilled, accepts a numeric (0 = disabled).}

\item{permanent}{if \code{TRUE}, batches cannot be split.}

\item{name}{optional string. Unnamed batches from different \code{batch} activities are
independent. However, if you want to feed arrivals from different trajectories into a
same batch, you need to specify a common name across all your \code{batch} activities.}

\item{rule}{an optional callable object (a function) which will be applied to
every arrival to determine whether it should be included into the batch, thus}
}
\value{
The trajectory object.
}
\description{
Collect a number of arrivals before they can continue processing
or split a previously established batch.
}

