% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmer-methods.R
\name{add_resource}
\alias{add_resource}
\title{Add a Resource}
\usage{
add_resource(.env, name, capacity = 1, queue_size = Inf, mon = TRUE,
  preemptive = FALSE, preempt_order = c("fifo", "lifo"),
  queue_size_strict = FALSE, queue_priority = c(0, Inf))
}
\arguments{
\item{.env}{the simulation environment.}

\item{name}{the name of the resource.}

\item{capacity}{the capacity of the server, either a numeric or a
\code{\link{schedule}}, so that the value may change during the simulation.}

\item{queue_size}{the size of the queue, either a numeric or a
\code{\link{schedule}}, so that the value may change during the simulation.}

\item{mon}{whether the simulator must monitor this resource or not.}

\item{preemptive}{whether arrivals in the server can be preempted or not based
on seize priorities.}

\item{preempt_order}{if the resource is preemptive and preemption occurs with
more than one arrival in the server, this parameter defines which arrival should
be preempted first. It must be \code{fifo} (First In First Out: older preemptible
tasks are preempted first) or \code{lifo} (Last In First Out: newer preemptible tasks
are preempted first).}

\item{queue_size_strict}{if the resource is preemptive and preemption occurs,
this parameter controls whether the \code{queue_size} is a hard limit. By default,
preempted arrivals go to a dedicated queue, so that \code{queue_size} may be
exceeded. If this option is \code{TRUE}, preempted arrivals go to the standard
queue, and the maximum \code{queue_size} is guaranteed (rejection may occur).
Whenever an arrival is rejected (due to a server drop or a queue drop), it
will set the \code{finished} flag to \code{FALSE} in the output of
\code{\link{get_mon_arrivals}}. Unfinished arrivals can be handled with a
drop-out trajectory that can be set using the \code{\link{handle_unfinished}}
activity.}

\item{queue_priority}{the priority range required to be able to access the
queue if there is no room in the server (if a single value is provided, it is
treated as the minimum priority). By default, all arrivals can be enqueued.}
}
\value{
Returns the simulation environment.
}
\description{
Define a new resource in a simulation environment.
}
\seealso{
Convenience functions: \code{\link{schedule}}.
}
