% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_line_fun.R
\name{ggplot_line_col_facet}
\alias{ggplot_line_col_facet}
\title{Line ggplot that is coloured and facetted.}
\usage{
ggplot_line_col_facet(data, x_var, y_var, col_var, facet_var,
  tip_var = NULL, x_labels = waiver(), x_pretty_n = 5,
  x_expand = NULL, y_zero = TRUE, y_zero_line = NULL,
  y_trans = "identity", y_labels = waiver(), y_pretty_n = 5,
  y_expand = NULL, y_balance = FALSE, facet_scales = "fixed",
  facet_nrow = NULL, points = TRUE, point_size = 1, lines = TRUE,
  size = 0.5, pal = NULL, pal_rev = FALSE, legend_ncol = 3,
  title = "[Title]", subtitle = NULL, x_title = "[X title]",
  y_title = "[Y title]", col_title = "", caption = NULL,
  legend_labels = NULL, font_family = "Helvetica",
  font_size_title = NULL, font_size_body = NULL, title_wrap = 70,
  subtitle_wrap = 80, x_title_wrap = 50, y_title_wrap = 50,
  wrap_col_title = 25, caption_wrap = 80)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric or date variable to be on the x axis. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y axis. Required input.}

\item{col_var}{Unquoted categorical variable for lines and points to be coloured by. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{tip_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot). Defaults to NULL.}

\item{x_labels}{Argument to adjust the format of the x scale labels.}

\item{x_pretty_n}{The desired number of intervals on the x axis, as calculated by the pretty algorithm. Defaults to 5.}

\item{x_expand}{A vector of range expansion constants used to add some padding on the x scale.}

\item{y_zero}{TRUE or FALSE whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_zero_line}{TRUE or FALSE whether to add a zero reference line to the y axis. Defaults to NULL, which is TRUE if there are positive and negative values in y_var. Otherwise it is FALSE.}

\item{y_trans}{A string specifying a transformation for the y axis scale, such as "log10" or "sqrt". Defaults to "identity".}

\item{y_labels}{Argument to adjust the format of the y scale labels.}

\item{y_pretty_n}{The desired number of intervals on the y axis, as calculated by the pretty algorithm. Defaults to 5.}

\item{y_expand}{A vector of range expansion constants used to add some padding on the y scale.}

\item{y_balance}{Add balance to the y axis so that zero is in the centre of the y scale. Only applicable where facet_scales equals "fixed" or "free_x".}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{facet_nrow}{The number of rows of facetted plots. Defaults to NULL, which generally chooses 2 rows.}

\item{points}{TRUE or FALSE of whether to include points. Defaults to TRUE.}

\item{point_size}{Size of points. Defaults to 1. Only applicable to where points equals TRUE.}

\item{lines}{TRUE or FALSE of whether to include lines. Defaults to TRUE.}

\item{size}{Size of lines. Defaults to 0.5. Only applicable to where lines equals TRUE.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects a default palette.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{legend_ncol}{The number of columns in the legend.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{x_title}{X axis title string. Defaults to "[X title]".}

\item{y_title}{Y axis title string. Defaults to "[Y title]".}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{legend_labels}{A vector of manual legend label values. Defaults to NULL, which results in automatic labels.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{wrap_col_title}{Number of characters to wrap the colour title to. Defaults to 25.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}
}
\value{
A ggplot object.
}
\description{
Line ggplot that is coloured and facetted.
}
\examples{
library(dplyr)

plot_data <- storms \%>\%
  mutate(status = stringr::str_to_sentence(status)) \%>\%
  group_by(year, status) \%>\%
  summarise(wind = round(mean(wind), 2)) 

 ggplot_line_col_facet(plot_data, year, wind, status, status)

}
