% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCorData.R
\name{genCorData}
\alias{genCorData}
\title{Create correlated data}
\usage{
genCorData(
  n,
  mu,
  sigma,
  corMatrix = NULL,
  rho,
  corstr = "ind",
  cnames = NULL,
  idname = "id"
)
}
\arguments{
\item{n}{Number of observations}

\item{mu}{A vector of means. The length of mu must be nvars.}

\item{sigma}{Standard deviation of variables. If standard deviation differs for
each variable, enter as a vector with the same length as the mean vector mu. If
the standard deviation is constant across variables, as single value can be entered.}

\item{corMatrix}{Correlation matrix can be entered directly. It must be symmetrical and
positive semi-definite. It is not a required field; if a matrix is not provided, then a
structure and correlation coefficient rho must be specified.}

\item{rho}{Correlation coefficient, -1 <= rho <= 1. Use if corMatrix is not provided.}

\item{corstr}{Correlation structure of the variance-covariance matrix
defined by sigma and rho. Options include "ind" for an independence
structure, "cs" for a compound symmetry structure, and "ar1" for an
autoregressive structure.}

\item{cnames}{Explicit column names. A single string with names separated
by commas. If no string is provided, the default names will be V#, where #
represents the column.}

\item{idname}{The name of the index id name. Defaults to "id."}
}
\value{
A data.table with n rows and the k + 1 columns, where k is the number of
means in the vector mu.
}
\description{
Create correlated data
}
\examples{
mu <- c(3, 8, 15)
sigma <- c(1, 2, 3)

corMat <- matrix(c(1, .2, .8, .2, 1, .6, .8, .6, 1), nrow = 3)

dtcor1 <- genCorData(1000, mu = mu, sigma = sigma, rho = .7, corstr = "cs")
dtcor2 <- genCorData(1000, mu = mu, sigma = sigma, corMatrix = corMat)

dtcor1
dtcor2

round(var(dtcor1[,.(V1, V2, V3)]), 3)
round(cor(dtcor1[,.(V1, V2, V3)]), 2)

round(var(dtcor2[,.(V1, V2, V3)]), 3)
round(cor(dtcor2[,.(V1, V2, V3)]), 2)
}
