% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{genData}
\alias{genData}
\title{Calling function to simulate data}
\usage{
genData(n, dtDefs = NULL, id = "id", envir = parent.frame())
}
\arguments{
\item{n}{the number of observations required in the data set.}

\item{dtDefs}{name of definitions data.table/data.frame. If no definitions
are provided
a data set with ids only is generated.}

\item{id}{The string defining the id of the record}

\item{envir}{Environment the data definitions are evaluated in.
Defaults to \link[base:sys.parent]{base::parent.frame}.}
}
\value{
A data.table that contains the simulated data.
}
\description{
Calling function to simulate data
}
\examples{
genData(5)
genData(5, id = "grpID")

def <- defData(
  varname = "xNr", dist = "nonrandom", formula = 7,
  id = "idnum"
)
def <- defData(def,
  varname = "xUni", dist = "uniform",
  formula = "10;20"
)
def <- defData(def,
  varname = "xNorm", formula = "xNr + xUni * 2",
  dist = "normal", variance = 8
)
def <- defData(def,
  varname = "xPois", dist = "poisson",
  formula = "xNr - 0.2 * xUni", link = "log"
)
def <- defData(def,
  varname = "xCat", formula = "0.3;0.2;0.5",
  dist = "categorical"
)
def <- defData(def,
  varname = "xGamma", dist = "gamma", formula = "5+xCat",
  variance = 1, link = "log"
)
def <- defData(def,
  varname = "xBin", dist = "binary", formula = "-3 + xCat",
  link = "logit"
)
def

genData(5, def)
}
\concept{generate_data}
