#  Copyright (c) 2024 Merck & Co., Inc., Rahway, NJ, USA and its affiliates.
#  All rights reserved.
#
#  This file is part of the simtrial program.
#
#  simtrial is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

#' Cut a dataset for analysis at a specified event count
#'
#' Takes a time-to-event data set and cuts the data at which an
#' event count is reached.
#'
#' @param x A time-to-event dataset, for example, generated by [sim_pw_surv()].
#' @param event Event count at which data cutoff is to be made.
#'
#' @return A data frame ready for survival analysis, including columns
#'   time to event (`tte`), `event`, the `stratum`, and the `treatment`.
#'
#' @export
#'
#' @examples
#' # Use default enrollment and event rates at cut at 100 events
#' x <- sim_pw_surv(n = 200) |> cut_data_by_event(100)
#' table(x$event, x$treatment)
cut_data_by_event <- function(x, event) {
  cut_date <- get_cut_date_by_event(x, event)
  ans <- x |> cut_data_by_date(cut_date = cut_date)
  return(ans)
}
