% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_sarima}
\alias{gen_sarima}
\title{Generate Seasonal Autoregressive Order P - Moving Average Order Q (SARMA(p,q)x(P,Q)) Model}
\usage{
gen_sarima(N, ar, d, ma, sar, sd, sma, sigma2 = 1.5, s = 12L, n_start = 0L)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{ar}{A \code{vec} that contains the AR coefficients.}

\item{d}{An \code{integer} that indicates a non-seasonal difference.}

\item{ma}{A \code{vec} that contains the MA coefficients.}

\item{sar}{A \code{vec} that contains the SAR coefficients.}

\item{sd}{An \code{integer} that indicates a seasonal difference.}

\item{sma}{A \code{vec} that contains the SMA coefficients.}

\item{sigma2}{A \code{double} that contains process variance.}

\item{s}{An \code{integer} that contains a seasonal id.}

\item{n_start}{An \code{unsigned int} that indicates the amount of observations to be used for the burn in period.}
}
\value{
A \code{vec} that contains the generated observations.
}
\description{
Generate an ARMA(P,Q) process with supplied vector of Autoregressive Coefficients (\eqn{\phi}), Moving Average Coefficients (\eqn{\theta}), and \eqn{\sigma^2}.
}
\details{
The innovations are generated from a normal distribution.
The \eqn{\sigma^2} parameter is indeed a variance parameter. 
This differs from R's use of the standard deviation, \eqn{\sigma}.
}
\keyword{internal}
