% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{summariseSimulation}
\alias{summariseSimulation}
\title{Returns a summary data-frame of a simulation.}
\usage{
summariseSimulation(simdf, inds = unique(simdf$Ind),
  trials = unique(simdf$trial), timeMin = min(simdf$time),
  timeMax = max(simdf$time), mergeAllele = T, mergePTM = T,
  mergeComplexes = F, verbose = T)
}
\arguments{
\item{simdf}{The data frame with the result of the simulation (see \code{\link{simulateInSilicoSystem}}).}

\item{inds}{A vector of in silico individual names for which to compute the summary values.}

\item{trials}{A vector of trials ID (= number) to use for the summary.}

\item{timeMin}{Numeric. The minimum simulation time to take into account. Default value set to the minimum time in the simulation.}

\item{timeMax}{Numeric. The maximum simulation time to take into account. Default value set to the maximum time in the simulation.}

\item{mergeAllele}{Are the gene products originating from different alleles merged? Default TRUE. Also see \code{\link{mergeAlleleAbundance}}}

\item{mergePTM}{Are the modified and non-modified versions of the proteins merged? Default TRUE. Also see \code{\link{mergePTMAbundance}}}

\item{mergeComplexes}{Are the free and in complex gene products merged? Default FALSE. Also see \code{\link{mergeComplexesAbundance}}}

\item{verbose}{If TRUE (default), print the individuals, trials, min and max time considered for the computation of the summary.}
}
\value{
A data-frame giving for each component (rows) and each individual (columns) the max and final average abundance over the different trials.
}
\description{
Returns a summary data-frame of a simulation giving the maximum average abundance of each component over the different trials and the average abundance of the components at the final time of the simulation, for the selected in silico individuals.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 5, regcomplexes = "none")
mypop = createInSilicoPopulation(15, mysystem, ploidy = 2)
sim = simulateParallelInSilicoSystem(mysystem, mypop, 100, ntrials = 5)
summariseSimulation(sim$Simulation, c("Ind1", "Ind2", "Ind3", "Ind4"))
}
}
