% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.classified_image}
\alias{plot.classified_image}
\title{Plot classified images}
\usage{
\method{plot}{classified_image}(
  x,
  y,
  ...,
  tiles = NULL,
  title = "Classified Image",
  legend = NULL,
  palette = "Spectral",
  rev = TRUE
)
}
\arguments{
\item{x}{Object of class "classified_image".}

\item{y}{Ignored.}

\item{...}{Further specifications for \link{plot}.}

\item{tiles}{Tiles to be plotted.}

\item{title}{Title of the plot.}

\item{legend}{Named vector that associates labels to colors.}

\item{palette}{Alternative palette that uses grDevices::hcl.pals().}

\item{rev}{Invert the order of hcl palette?}
}
\value{
A plot object produced by the ggplot2 package
                        with a color maps, where each pixel has the color
                        associated to a label, as defined by the legend
                        parameter.
}
\description{
plots a classified raster using ggplot.
}
\examples{
if (sits_run_examples()) {
    # select a set of samples
    samples_ndvi <- sits_select(samples_modis_4bands, bands = c("NDVI"))
    # create a random forest model
    rfor_model <- sits_train(samples_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "X2", "tile", "band", "date")
    )
    # classify a data cube
    probs_cube <- sits_classify(data = cube, ml_model = rfor_model)
    # label cube with the most likely class
    label_cube <- sits_label_classification(probs_cube)
    # plot the resulting classified image
    plot(label_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
