% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.uncertainty_cube}
\alias{plot.uncertainty_cube}
\title{Plot uncertainty cubes}
\usage{
\method{plot}{uncertainty_cube}(
  x,
  ...,
  tiles = NULL,
  n_colors = 14,
  intervals = "log",
  palette = "YlOrRd"
)
}
\arguments{
\item{x}{Object of class "probs_image".}

\item{...}{Further specifications for \link{plot}.}

\item{tiles}{Tiles to be plotted.}

\item{n_colors}{Number of colors to plot.}

\item{intervals}{Type of class intervals.}

\item{palette}{HCL palette used for visualization.}
}
\value{
A plot object produced by the stars package
                      with a map showing the uncertainty associated
                      to each classified pixel.
}
\description{
plots a probability cube using stars
}
\note{
\itemize{Possible class intervals
 \item{"sd":} {intervals based on the average and standard deviation.}
 \item{"equal": } {divides the range of the variable into n parts.}
 \item{"quantile": } {quantile breaks}
 \item{"pretty": } {number of breaks likely to be legible.}
 \item{"log" :} {logarithm plot.}
 }
}
\examples{
if (sits_run_examples()) {
    # select a set of samples
    samples_ndvi <- sits_select(samples_modis_4bands, bands = c("NDVI"))
    # create a random forest model
    rfor_model <- sits_train(samples_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "X2", "tile", "band", "date")
    )
    # classify a data cube
    probs_cube <- sits_classify(data = cube, ml_model = rfor_model)
    # calculate uncertainty
    uncert_cube <- sits_uncertainty(probs_cube)
    # plot the resulting uncertainty cube
    plot(uncert_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
