% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_label_classification.R
\name{sits_label_classification}
\alias{sits_label_classification}
\title{Build a labelled image from a probability cube}
\usage{
sits_label_classification(
  cube,
  multicores = 2,
  memsize = 4,
  output_dir = ".",
  version = "v1"
)
}
\arguments{
\item{cube}{Classified image data cube.}

\item{multicores}{Number of workers to label the classification in
parallel.}

\item{memsize}{maximum overall memory (in GB) to label the
classification.}

\item{output_dir}{Output directory for classified files.}

\item{version}{Version of resulting image
(in the case of multiple runs).}
}
\value{
A data cube with an image with the classified map.
}
\description{
Takes a set of classified raster layers with probabilities,
             and label them based on the maximum probability for each pixel.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # select a set of samples
    samples_ndvi <- sits_select(samples_modis_4bands, bands = c("NDVI"))
    # create a random forest model
    rfor_model <- sits_train(samples_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "X2", "tile", "band", "date")
    )
    # classify a data cube
    probs_cube <- sits_classify(data = cube, ml_model = rfor_model)
    # plot the probability cube
    plot(probs_cube)
    # smooth the probability cube using Bayesian statistics
    bayes_cube <- sits_smooth(probs_cube)
    # plot the smoothed cube
    plot(bayes_cube)
    # label the probability cube
    label_cube <- sits_label_classification(bayes_cube)
    # plot the labelled cube
    plot(label_cube)
}
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
