% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_source_api.R
\name{source_functions}
\alias{source_functions}
\alias{.sources}
\alias{.source_check}
\alias{.source_new}
\alias{.source_service}
\alias{.source_s3class}
\alias{.source_url}
\title{Source functions}
\usage{
.sources()

.source_check(source)

.source_new(source, collection = NULL, is_local = FALSE)

.source_service(source)

.source_s3class(source)

.source_url(source)
}
\arguments{
\item{source}{A \code{character} value referring to a valid data source.}
}
\value{
The values returned by each function are described as follows.

\code{.sources()} returns a \code{character} vector
with all sources names available in sits.

\code{.source_check()} returns \code{NULL} if no error occurs.

\code{.source_new()} returns a \code{character} vector with the
S3 class defined in source's \code{S3class} attribute.

\code{.source_service()} returns a \code{character} value or
\code{NA} if no service is associated with a given source.

\code{.source_s3class()} returns a \code{character} vector.
sits uses these classes to run source functions.

\code{.source_url()} returns a \code{character} value or \code{NA}
if no URL is associated with a given source.
}
\description{
These functions provide an API to handle/retrieve data from sources.

\code{.sources()} lists all sources available in sits.

\code{.source_check()} checks if a source is available in sits.

\code{.source_new()} creates an object with a corresponding
S3 class defined in a given source and collection.

\code{.source_service()} returns the service associated
with a given source.

\code{.source_s3class()} returns the s3 class associated
with a given source.

\code{.source_url()} get an URL associated with a source. Not
all sources have an URL. In these cases, an \code{NA} is returned.
}
\keyword{internal}
