% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_predictors.R
\name{sits_pred_sample}
\alias{sits_pred_sample}
\title{Obtain a fraction of the predictors data frame}
\usage{
sits_pred_sample(pred, frac)
}
\arguments{
\item{pred}{X-Y predictors: a data.frame with one row per sample.}

\item{frac}{Fraction of the X-Y predictors to be extracted}
}
\value{
A data.frame with the chosen fraction of the X-Y predictors.
}
\description{
Many machine learning algorithms (especially deep learning)
use part of the original samples as test data to adjust its hyperparameters
and to find an optimal point of convergence using gradient descent.
This function extracts a fraction of the predictors to serve as test values
for the deep learning algorithm.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    pred <- sits_predictors(samples_modis_ndvi)
    pred_frac <- sits_pred_sample(pred, frac = 0.5)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
