% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.variance_cube}
\alias{plot.variance_cube}
\title{Plot variance cubes}
\usage{
\method{plot}{variance_cube}(
  x,
  ...,
  tile = x[["tile"]][[1]],
  roi = NULL,
  labels = NULL,
  palette = "YlGnBu",
  rev = FALSE,
  type = "map",
  quantile = 0.75,
  scale = 1,
  max_cog_size = 1024,
  legend_position = "inside",
  legend_title = "logvar"
)
}
\arguments{
\item{x}{Object of class "variance_cube".}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{roi}{Spatial extent to plot in WGS 84 - named vector
with either (lon_min, lon_max, lat_min, lat_max) or
(xmin, xmax, ymin, ymax)}

\item{labels}{Labels to plot.}

\item{palette}{RColorBrewer palette}

\item{rev}{Reverse order of colors in palette?}

\item{type}{Type of plot ("map" or "hist")}

\item{quantile}{Minimum quantile to plot}

\item{scale}{Scale to plot map (0.4 to 1.0)}

\item{max_cog_size}{Maximum size of COG overviews (lines or columns)}

\item{legend_position}{Where to place the legend (default = "inside")}

\item{legend_title}{Title of legend (default = "probs")}
}
\value{
A plot containing local variances associated to the
                       logit probability for each pixel and each class.
}
\description{
plots a variance cube
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # obtain a variance cube
    var_cube <- sits_variance(probs_cube, output_dir = tempdir())
    # plot the variance cube
    plot(var_cube)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
