% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_summary.R
\name{summary.variance_cube}
\alias{summary.variance_cube}
\title{Summarise variance cubes}
\usage{
\method{summary}{variance_cube}(
  object,
  ...,
  intervals = 0.05,
  sample_size = 10000,
  quantiles = c("75\%", "80\%", "85\%", "90\%", "95\%", "100\%")
)
}
\arguments{
\item{object}{Object of class "class_cube"}

\item{...}{Further specifications for \link{summary}.}

\item{intervals}{Intervals to calculate the quantiles}

\item{sample_size}{The size of samples will be extracted from the variance
cube.}

\item{quantiles}{Quantiles to be shown}
}
\value{
A summary of a variance cube
}
\description{
This is a generic function. Parameters depend on the specific
type of input.
}
\examples{
if (sits_run_examples()) {
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    variance_cube <- sits_variance(
        data = probs_cube,
        output_dir = tempdir()
    )
    summary(variance_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
