% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits-package.R
\docType{package}
\name{sits-package}
\alias{sits-package}
\alias{sits}
\title{sits}
\description{
Satellite Image Time Series Analysis
             for Earth Observation Data Cubes
}
\note{
The main \code{sits} classification workflow has the following steps:
\enumerate{
     \item{\code{\link[sits]{sits_cube}}: selects a ARD image collection from
         a cloud provider.}
     \item{\code{\link[sits]{sits_cube_copy}}: copies an ARD image collection
         from a cloud provider to a local directory for faster processing.}
     \item{\code{\link[sits]{sits_regularize}}: create a regular data cube
         from an ARD image collection.}
     \item{\code{\link[sits]{sits_apply}}: create new indices by combining
         bands of a  regular data cube (optional).}
     \item{\code{\link[sits]{sits_get_data}}: extract time series
         from a regular data cube based on user-provided labelled samples.}
     \item{\code{\link[sits]{sits_train}}: train a machine learning
         model based on image time series.}
     \item{\code{\link[sits]{sits_classify}}: classify a data cube
         using a machine learning model and obtain a probability cube.}
     \item{\code{\link[sits]{sits_smooth}}: post-process a probability cube
         using a spatial smoother to remove outliers and
         increase spatial consistency.}
     \item{\code{\link[sits]{sits_label_classification}}: produce a
         classified map by selecting the label with the highest probability
         from a smoothed cube.}
}
}
\section{Purpose}{


The SITS package provides a set of tools for analysis,
visualization and classification of satellite image time series.
It includes methods for filtering, clustering, classification,
and post-processing.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/e-sensing/sits/}
  \item \url{https://e-sensing.github.io/sitsbook/}
  \item \url{https://e-sensing.github.io/sits/}
  \item Report bugs at \url{https://github.com/e-sensing/sits/issues}
}

}
\author{
\strong{Maintainer}: Gilberto Camara \email{gilberto.camara.inpe@gmail.com} [thesis advisor]

Authors:
\itemize{
  \item Rolf Simoes \email{rolfsimoes@gmail.com}
  \item Felipe Souza \email{felipe.carvalho@inpe.br}
  \item Felipe Carlos \email{efelipecarlos@gmail.com}
}

Other contributors:
\itemize{
  \item Lorena Santos \email{lorena.santos@inpe.br} [contributor]
  \item Charlotte Pelletier \email{charlotte.pelletier@univ-ubs.fr} [contributor]
  \item Estefania Pizarro \email{eapizarroa@ine.gob.cl} [contributor]
  \item Karine Ferreira \email{karine.ferreira@inpe.br} [contributor, thesis advisor]
  \item Alber Sanchez \email{alber.ipia@inpe.br} [contributor]
  \item Alexandre Assuncao \email{alexcarssuncao@gmail.com} [contributor]
  \item Daniel Falbel \email{dfalbel@gmail.com} [contributor]
  \item Gilberto Queiroz \email{gilberto.queiroz@inpe.br} [contributor]
  \item Johannes Reiche \email{johannes.reiche@wur.nl} [contributor]
  \item Pedro Andrade \email{pedro.andrade@inpe.br} [contributor]
  \item Pedro Brito \email{pedro_brito1997@hotmail.com} [contributor]
  \item Renato Assuncao \email{assuncaoest@gmail.com} [contributor]
  \item Ricardo Cartaxo \email{rcartaxoms@gmail.com} [contributor]
}

}
