% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_bbox.R
\name{sits_bbox}
\alias{sits_bbox}
\alias{sits_bbox.sits}
\alias{sits_bbox.raster_cube}
\alias{sits_bbox.tbl_df}
\alias{sits_bbox.default}
\title{Get the bounding box of the data}
\usage{
sits_bbox(data, ..., crs = "EPSG:4326", as_crs = NULL)

\method{sits_bbox}{sits}(data, ..., crs = "EPSG:4326", as_crs = NULL)

\method{sits_bbox}{raster_cube}(data, ..., as_crs = NULL)

\method{sits_bbox}{tbl_df}(data, ..., crs = "EPSG:4326", as_crs = NULL)

\method{sits_bbox}{default}(data, ..., crs = "EPSG:4326", as_crs = NULL)
}
\arguments{
\item{data}{samples (class "sits") or \code{cube}.}

\item{...}{parameters for specific types}

\item{crs}{CRS of the time series.}

\item{as_crs}{CRS to project the resulting \code{bbox}.}
}
\value{
A \code{bbox}.
}
\description{
Obtain a vector of limits (either on lat/long for time series
              or in projection coordinates in the case of cubes)
}
\note{
Time series in \code{sits} are associated with lat/long
values in WGS84, while each data cubes is associated to a
cartographic projection. To obtain the bounding box
of a data cube in a different projection than the original,
use the \code{as_crs} parameter.
}
\examples{
if (sits_run_examples()) {
    # get the bbox of a set of samples
    sits_bbox(samples_modis_ndvi)
    # get the bbox of a cube in WGS84
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    sits_bbox(cube, as_crs = "EPSG:4326")
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolfsimoes@gmail.com}
}
