% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.torch_model}
\alias{plot.torch_model}
\title{Plot Torch (deep learning) model}
\usage{
\method{plot}{torch_model}(x, y, ...)
}
\arguments{
\item{x}{Object of class "torch_model".}

\item{y}{Ignored.}

\item{...}{Further specifications for \link{plot}.}
}
\value{
A plot object produced by the ggplot2 package
                      showing the evolution of the loss and
                      accuracy of the model.
}
\description{
Plots a deep learning model developed using torch.
}
\note{
This code has been lifted from the "keras" package.

Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # Retrieve the samples for Mato Grosso
    # train a tempCNN model
    ml_model <- sits_train(samples_modis_ndvi, ml_method = sits_tempcnn)
    # plot the model
    plot(ml_model)
}
}
\author{
Felipe Carvalho, \email{lipecaso@gmail.com}

Rolf Simoes, \email{rolfsimoes@gmail.com}

Alber Sanchez, \email{alber.ipia@inpe.br}
}
