% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_sample_functions.R
\name{sits_sample}
\alias{sits_sample}
\title{Sample a percentage of a time series}
\usage{
sits_sample(data, frac = 0.2, oversample = TRUE)
}
\arguments{
\item{data}{Sits time series tibble}

\item{frac}{Percentage of samples to extract
(range: 0.0 to 2.0, default = 0.2)}

\item{oversample}{Logical: oversample classes with small number of samples?
(TRUE/FALSE)}
}
\value{
A sits tibble with a fixed quantity of samples.
}
\description{
Takes a sits tibble with different labels and
             returns a new tibble. For a given field as a group criterion,
             this new tibble contains a percentage
             of the total number of samples per group.
             If frac > 1 , all sampling will be done with replacement.
}
\examples{
# Retrieve a set of time series with 2 classes
data(cerrado_2classes)
# Print the labels of the resulting tibble
summary(cerrado_2classes)
# Sample by fraction
data_02 <- sits_sample(cerrado_2classes, frac = 0.2)
# Print the labels
summary(data_02)
}
\author{
Rolf Simoes, \email{rolfsimoes@gmail.com}
}
