% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sjc.cluster}
\alias{sjc.cluster}
\title{Compute hierarchical or kmeans cluster analysis}
\usage{
sjc.cluster(data, groupcount, method = "h", distance = "euclidean",
  agglomeration = "ward", iter.max = 20, algorithm = "Hartigan-Wong")
}
\arguments{
\item{data}{The data frame containing all variables that should be used for the
cluster analysis.}

\item{groupcount}{The amount of groups (clusters) that should be retrieved. May also be
a set of initial (distinct) cluster centres, in case \code{method} is \code{"kmeans"}
(see \code{\link{kmeans}} for details on \code{centers} parameter). If \code{groupcount}
indicates a number of clusters, following functions may be helpful for estimating the
amount of clusters:
\itemize{
  \item Use \code{\link{sjc.elbow}}-function to determine the group-count depending on the elbow-criterion.
  \item If using kmeans as \code{method}, use \code{\link{sjc.kgap}}-function to determine the group-count according to the gap-statistic.
  \item If using hierarchical as \code{method} (default), use  \code{\link{sjc.dend}}-function to inspect different cluster group solutions.
  \item Use \code{\link{sjc.grpdisc}}-function to inspect the goodness of grouping (accuracy of classification).
  }}

\item{method}{Indicates the clustering method. If \code{"hclust"} (default), a hierachical
clustering using the ward method is computed. Use \code{"kmeans"} to compute a k-means clustering.
You can specifiy inital letters only.}

\item{distance}{The distance measure to be used when \code{"method"} is \code{"hclust"} (for hierarchical
clustering). This must be one of \code{"euclidean"} (default), \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"} or \code{"minkowski"}. See \code{\link{dist}}.}

\item{agglomeration}{The agglomeration method to be used when \code{"method"} is \code{"hclust"} (for hierarchical
clustering). This should be one of \code{"ward"}, \code{"single"}, \code{"complete"}, \code{"average"},
\code{"mcquitty"}, \code{"median"} or \code{"centroid"}. Default is \code{"ward"}. See \code{\link{hclust}}.}

\item{iter.max}{the maximum number of iterations allowed. Only applies, if \code{method}
is \code{"kmeans"}. See \code{\link{kmeans}} for details on this parameter.}

\item{algorithm}{algorithm used for calculating kmeans cluster. Only applies, if \code{method}
is \code{"kmeans"}. May be one of \code{"Hartigan-Wong"} (default), \code{"Lloyd"} (used by SPSS),
or \code{"MacQueen"}. See \code{\link{kmeans}} for details on this parameter.}
}
\value{
The group classification for each observation as vector. This group
          classification can be used for \code{\link{sjc.grpdisc}}-function to
          check the goodness of classification.
          The returned vector includes missing values, so it can be appended
          to the original data frame \code{data}.
}
\description{
Compute hierarchical or kmeans cluster analysis and returns the group
               association for each observation as vector.
}
\note{
To get similar results as in SPSS Quick Cluster function, following points
       have to be considered:
       \enumerate{
         \item Use the \code{/PRINT INITIAL} option for SPSS Quick Cluster to get a table with initial cluster centers.
         \item Create a \code{\link{matrix}} of this table, by consecutively copying the values, one row after another, from the SPSS output into a matrix and specifying \code{nrow} and \code{ncol} parameters.
         \item Use \code{algorithm="Lloyd"}.
         \item Use the same amount of \code{iter.max} both in SPSS and this \code{sjc.qclus}.
       }
       This ensures a fixed initial set of cluster centers (as in SPSS), while \code{\link{kmeans}} in R
       always selects initial cluster sets randomly.
}
\examples{
# Hierarchical clustering of mtcars-dataset
groups <- sjc.cluster(mtcars, 5)

# K-means clustering of mtcars-dataset
groups <- sjc.cluster(mtcars, 5, method="k")
}
\seealso{
\code{\link{sjc.qclus}} \cr
         \code{\link{sjc.dend}} \cr
         \code{\link{sjc.grpdisc}} \cr
         \code{\link{sjc.elbow}} \cr
         \code{\link{kmeans}} \cr
         \code{\link{hclust}} \cr
         Maechler M, Rousseeuw P, Struyf A, Hubert M, Hornik K (2014) cluster: Cluster Analysis Basics and Extensions. R package.
}

