% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotPolynomials.R
\name{sjp.poly}
\alias{sjp.poly}
\title{Plot polynomials for (generalized) linear regression}
\usage{
sjp.poly(x, poly.term, poly.degree, poly.scale = FALSE, fun = NULL,
  axisTitle.x = NULL, axisTitle.y = NULL, showScatterPlot = TRUE,
  showLoess = TRUE, showLoessCI = TRUE, showPValues = TRUE,
  geom.colors = NULL, geom.size = 0.8, loessLineColor = "#808080",
  pointColor = "#404040", pointAlpha = 0.2, printPlot = TRUE)
}
\arguments{
\item{x}{a vector, representing the response variable of a linear (mixed) model; or
a linear (mixed) model as returned by \code{\link{lm}} or \code{\link[lme4]{lmer}}.}

\item{poly.term}{if \code{x} is a vector, \code{poly.term} should also be a vector, representing
the polynomial term (independent variabl) in the model; if \code{x} is a
fitted model, \code{poly.term} should be the polynomial term's name as character string.
See 'Examples'.}

\item{poly.degree}{numeric, or numeric vector, indicating the degree of the polynomial.
If \code{poly.degree} is a numeric vector, multiple polynomial curves for
each degree are plotted. See 'Examples'.}

\item{poly.scale}{logical, if \code{TRUE}, \code{poly.term} will be scaled before
linear regression is computed. Default is \code{FALSE}. Scaling the polynomial
term may have an impact on the resulting p-values.}

\item{fun}{linear function when modelling polynomial terms. Use \code{fun = "lm"}
for linear models, or \code{fun = "glm"} for generalized linear models.
When \code{x} is not a vector, but a fitted model object, the function
is detected automatically. If \code{x} is a vector, \code{fun} defaults
to \code{"lm"}.}

\item{axisTitle.x}{A label for the x axis. Use \code{NULL} to automatically detect
variable names that will be used as title (see \code{\link[sjmisc]{set_var_labels}}) for details).}

\item{axisTitle.y}{A label for the y axis. Use \code{NULL} to automatically detect
variable names that will be used as title (see \code{\link[sjmisc]{set_var_labels}}) for details).}

\item{showScatterPlot}{If \code{TRUE} (default), a scatter plot of response and predictor values
for each predictor of the fitted model \code{fit} is plotted.
Only applies if \code{type = "lm"} and fitted model has only one predictor,
or if \code{type = "pred"} or \code{type = "resid"}.}

\item{showLoess}{If \code{TRUE}, an additional loess-smoothed line is plotted.}

\item{showLoessCI}{If \code{TRUE}, a confidence region for the loess-smoothed line
will be plotted.}

\item{showPValues}{logical, if \code{TRUE} (default), p-values for polynomial terms are
printed to the console.}

\item{geom.colors}{User defined color palette for geoms. Must either be vector with two color values
or a specific color palette code. See 'Note' in \code{\link{sjp.grpfrq}}.}

\item{geom.size}{size resp. width of plotted lines.}

\item{loessLineColor}{color of the loess-smoothed line. Only applies, if \code{showLoess = TRUE}.}

\item{pointColor}{color of the scatter plot's point. Only applies, if \code{showScatterPlot = TRUE}.}

\item{pointAlpha}{The alpha values of the scatter plot's point-geoms. Default is 0.2.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(insisibily) returns the ggplot-object with the complete plot (\code{plot})
          as well as the data frame that was used for setting up the
          ggplot-object (\code{df}).
}
\description{
This function plots a scatter plot of a term \code{poly.term}
               against a response variable \code{x} and adds - depending on
               the amount of numeric values in \code{poly.degree} - multiple
               polynomial curves. A loess-smoothed line can be added to see
               which of the polynomial curves fits best to the data.
}
\details{
For each polynomial degree, a simple linear regression on \code{x} (resp.
           the extracted response, if \code{x} is a fitted model) is performed,
           where only the polynomial term \code{poly.term} is included as independent variable.
           Thus, \code{lm(y ~ x + I(x^2) + ... + I(x^i))} is repeatedly computed
           for all values in \code{poly.degree}, and the predicted values of
           the reponse are plotted against the raw values of \code{poly.term}.
           If \code{x} is a fitted model, other covariates are ignored when
           finding the best fitting polynomial. \cr \cr
           This function evaluates raw polynomials, \emph{not orthogonal} polynomials.
           Polynomials are computed using the \code{\link{poly}} function,
           with parameter \code{raw = TRUE}. \cr \cr
           To find out which polynomial degree fits best to the data, a loess-smoothed
           line can be added (with \code{showLoess = TRUE}). The polynomial curves
           that comes closest to the loess-smoothed line should be the best
           fit to the data.
}
\examples{
library(sjmisc)
data(efc)
# linear fit. loess-smoothed line indicates a more
# or less cubic curve
sjp.poly(efc$c160age, efc$quol_5, 1)

# quadratic fit
sjp.poly(efc$c160age, efc$quol_5, 2)

# linear to cubic fit
sjp.poly(efc$c160age, efc$quol_5,
         1:4, showScatterPlot = FALSE)


library(sjmisc)
data(efc)
# fit sample model
fit <- lm(tot_sc_e ~ c12hour + e17age + e42dep, data = efc)
# inspect relationship between predictors and response
sjp.lm(fit, type = "pred",
       showLoess = TRUE, showScatterPlot = FALSE)
# "e17age" does not seem to be linear correlated to response
# try to find appropiate polynomial. Grey line (loess smoothed)
# indicates best fit. Looks like x^4 has the best fit,
# however, only x^3 has significant p-values.
sjp.poly(fit, "e17age", 2:4, showScatterPlot = FALSE)

\dontrun{
# fit new model
fit <- lm(tot_sc_e ~ c12hour + e42dep +
          e17age + I(e17age^2) + I(e17age^3),
          data = efc)
# plot marginal effects of polynomial term
sjp.lm(fit, type = "poly", poly.term = "e17age")}
}
\seealso{
To plot marginal effects of polynomial terms, call \code{\link{sjp.lm}} with \code{type = "poly"},
           or \code{\link{sjp.lmer}} respectively for linear mixed models.
}

