% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotScatter.R
\name{sjp.scatter}
\alias{sjp.scatter}
\title{Plot (grouped) scatter plots}
\usage{
sjp.scatter(x = NULL, y = NULL, grp = NULL, title = "",
  legend.title = NULL, legend.labels = NULL, dot.labels = NULL,
  axis.titles = NULL, wrap.title = 50, wrap.legend.title = 20,
  wrap.legend.labels = 20, geom.size = 2, label.size = 3,
  geom.colors = NULL, show.axis.values = TRUE, fit.line.grps = FALSE,
  fit.line = FALSE, show.ci = FALSE, fitmethod = "lm",
  jitter.dots = FALSE, emph.dots = FALSE, auto.jitter = TRUE,
  jitter.ratio = 0.15, show.rug = FALSE, show.legend = TRUE,
  facet.grid = FALSE, prnt.plot = TRUE)
}
\arguments{
\item{x}{vector indicating the x positions. If not specified (i.e. if
\code{NULL}), a range from 1 to length of \code{y} is used to spread the
dots along the x axis.}

\item{y}{vector indicating the y positions. If not specified (i.e. if
\code{NULL}), a range from 1 to length of \code{x} is used to spread the
dots along the y axis.}

\item{grp}{grouping variable. If not \code{NULL}, the scatter plot will be grouped. See
'Examples'. Default is \code{NULL}, i.e. not grouping is done.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.}

\item{legend.title}{character vector, used as title for the plot legend.}

\item{legend.labels}{character vector with labels for the guide/legend.}

\item{dot.labels}{character vector with names for each coordinate pair given
by \code{x} and \code{y}, so text labels are added to the plot. 
Must be of same length as \code{x} and \code{y}.
If \code{dot.labels} has a different length, data points will be trimmed
to match \code{dot.labels}. If \code{dot.labels = NULL} (default),
no labels are printed.}

\item{axis.titles}{character vector of length one or two, defining the title(s)
for the x-axis and y-axis.}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title 
are displayed in one line and when a line break is inserted.}

\item{wrap.legend.labels}{numeric, determines how many chars of the legend labels are 
displayed in one line and when a line break is inserted.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size, 
depending on plot type and function). Note that bar and bin widths mostly 
need smaller values than dot sizes.}

\item{label.size}{Size of text labels if argument \code{dot.labels} is used.}

\item{geom.colors}{user defined color for geoms. See 'Details' in \code{\link{sjp.grpfrq}}.}

\item{show.axis.values}{logical, whether category, count or percentage values for the axis
should be printed or not.}

\item{fit.line.grps}{logical, if \code{TRUE}, a fitted line for each group
is drawn. See \code{fitmethod} to change the fit method of the fitted lines.}

\item{fit.line}{logical, if \code{TRUE}, a fitted line for the overall
scatterplot is drawn. See \code{fitmethod} to change the fit method
of the fitted line.}

\item{show.ci}{logical, if \code{TRUE}, depending on \code{type}, a confidence
interval or region is added to the plot.}

\item{fitmethod}{By default, a linear method (\code{"lm"}) is used for fitting
the fit lines. Possible values are for instance \code{"lm"}, \code{"glm"},
\code{"loess"} or \code{"auto"}.}

\item{jitter.dots}{logical, if \code{TRUE}, points will be jittered (to avoid overplotting).}

\item{emph.dots}{logical, if \code{TRUE}, overlapping points at same coordinates
will be becomme larger, so point size indicates amount of overlapping.}

\item{auto.jitter}{logical, if \code{TRUE}, points will be jittered according
to an overlap-estimation. A matrix of \code{x} and \code{y} values
is created and the amount of cells (indicating a unique point position)
is calculated. If more than 15\% (see \code{jitter.ratio}) of the
approximated amount of unique point coordinates seem to
overlap, they are automatically jittered.}

\item{jitter.ratio}{ratio of tolerated overlapping (see \code{auto.jitter}).
If approximated amount of overlapping  points exceed this ratio,
they are automatically jittered. Default is 0.15. Valid values range
between 0 and 1.}

\item{show.rug}{logical, if \code{TRUE}, a marginal rug plot is displayed
in the graph.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{facet.grid}{\code{TRUE} to arrange the lay out of of multiple plots 
in a grid of an integrated single plot. This argument calls 
\code{\link[ggplot2]{facet_wrap}} or \code{\link[ggplot2]{facet_grid}}
to arrange plots. Use \code{\link{plot_grid}} to plot multiple plot-objects 
as an arranged grid with \code{\link[gridExtra]{grid.arrange}}.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{data}).
}
\description{
Display scatter plot of two variables. Adding a grouping variable to
               the scatter plot is possible. Furthermore, fitted lines can be added
               for each group as well as for the overall plot.
}
\examples{
# load sample date
library(sjmisc)
data(efc)

# simple scatter plot, auto-jittering
sjp.scatter(efc$e16sex, efc$neg_c_7)

# simple scatter plot, no jittering needed
sjp.scatter(efc$c160age, efc$e17age)

# grouped scatter plot
sjp.scatter(efc$c160age, efc$e17age, efc$e42dep)

# grouped and jittered scatter plot with marginal rug plot
sjp.scatter(efc$e16sex,efc$neg_c_7, efc$c172code, show.rug = TRUE)

# grouped and labelled scatter plot, not using the auto-detection
# of labels, but instead pass labels as arguments
sjp.scatter(efc$c160age, efc$e17age, efc$e42dep,
            title = "Scatter Plot", legend.title = get_label(efc)['e42dep'],
            legend.labels = get_labels(efc)[['e42dep']],
            axis.titles = c(get_label(efc)['c160age'], get_label(efc)['e17age']),
            fit.line.grps = TRUE)

# grouped and labelled scatter plot as facets
sjp.scatter(efc$c160age,efc$e17age, efc$e42dep, fit.line.grps = TRUE,
            facet.grid = TRUE, show.ci = TRUE)

# plot residuals of fitted models
fit <- lm(neg_c_7 ~ quol_5, data = efc)
sjp.scatter(y = fit$residuals, fit.line = TRUE)

# "hide" axis titles
sjp.scatter(efc$c160age, efc$e17age, efc$e42dep, title = "", 
            axis.titles = c("", ""))

# plot text labels
pl <- c(1:10)
for (i in 1:10) 
  pl[i] <- paste(sample(c(0:9, letters, LETTERS), 8, replace = TRUE), collapse = "")
sjp.scatter(runif(10), runif(10), dot.labels = pl)

}
\seealso{
\href{http://www.strengejacke.de/sjPlot/sjp.scatter}{sjPlot manual: sjp.scatter}
}

