% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotResiduals.R
\name{sjp.resid}
\alias{sjp.resid}
\title{Plot predicted values and their residuals}
\usage{
sjp.resid(fit, geom.size = 2, remove.estimates = NULL, show.lines = TRUE,
  show.resid = TRUE, show.pred = TRUE, show.ci = F, prnt.plot = TRUE)
}
\arguments{
\item{fit}{fitted linear (mixed) regression model (including objects of class
\code{\link[nlme]{gls}} or \code{plm}).}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size, 
depending on plot type and function). Note that bar and bin widths mostly 
need smaller values than dot sizes.}

\item{remove.estimates}{character vector with coefficient names that indicate
which estimates should be removed from the plot.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{show.lines}{logical, if \code{TRUE}, a line connecting predicted and
residual values is plotted. Set this argument to \code{FALSE}, if
plot-building is too time consuming.}

\item{show.resid}{logical, if \code{TRUE}, residual values are plotted.}

\item{show.pred}{logical, if \code{TRUE}, predicted values are plotted.}

\item{show.ci}{logical, if \code{TRUE}, depending on \code{type}, a confidence
interval or region is added to the plot.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}),
          the residual pattern (\code{pattern}) as well as the data frame that
          was used for setting up the ggplot-object (\code{mydf}).
}
\description{
This function plots observed and predicted values of the response
             of linear (mixed) models for each coefficient and highlights the
             observed values according to their distance (residuals) to the 
             predicted values. This allows to investigate how well actual and 
             predicted values of the outcome fit across the predictor variables.
}
\note{
The actual (observed) values have a coloured fill, while the predicted
      values have a solid outline without filling.
}
\examples{
library(sjmisc)
data(efc)
# fit model
fit <- lm(neg_c_7 ~ c12hour + e17age + e42dep, data = efc)

# plot residuals for all independent variables
sjp.resid(fit)

# remove some independent variables from output
sjp.resid(fit, remove.estimates = c("e17age", "e42dep"))

# show pattern
sjp.resid(fit, remove.estimates = c("e17age", "e42dep"))$pattern

}

