% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotAnova.R
\name{sjp.aov1}
\alias{sjp.aov1}
\title{Plot One-Way-Anova tables}
\usage{
sjp.aov1(var.dep, var.grp, meansums = FALSE, title = NULL,
  axis.labels = NULL, rev.order = FALSE, string.interc = "(Intercept)",
  axis.title = "", axis.lim = NULL, geom.colors = c("#3366a0", "#aa3333"),
  geom.size = 3, wrap.title = 50, wrap.labels = 25, grid.breaks = NULL,
  show.values = TRUE, digits = 2, y.offset = 0.1, show.p = TRUE,
  show.summary = FALSE, prnt.plot = TRUE)
}
\arguments{
\item{var.dep}{dependent variable. Will be used with following formula:
\code{aov(var.dep ~ var.grp)}}

\item{var.grp}{factor with the cross-classifying variable, where \code{var.dep} 
is grouped into the categories represented by \code{var.grp}.}

\item{meansums}{logical, if \code{TRUE}, the values reported are the true group mean values (see also \code{\link{sjt.grpmean}}).
If \code{FALSE} (default), the values are reported in the standard way, i.e. the values indicate the difference of
the group mean in relation to the intercept (reference group).}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.
For effect-plots, may also be a character vector of length > 1,
to define titles for each sub-plot or facet.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{rev.order}{logical, if \code{TRUE}, order of categories (groups) is reversed.}

\item{string.interc}{string that indicates the reference group (intercept), that is appended to
the value label of the grouping variable. Default is \code{"(Intercept)"}.}

\item{axis.title}{character vector of length one or two (depending on
the plot function and type), used as title(s) for the x and y axis. 
If not specified, a default labelling  is chosen.}

\item{axis.lim}{numeric vector of length 2, defining the range of the plot axis.
Depending on plot type, may effect either x- or y-axis, or both.
For multiple plot outputs (e.g., from \code{type = "eff"} or 
\code{type = "slope"} in \code{\link{sjp.glm}}), \code{axis.lim} may
also be a list of vectors of length 2, defining axis limits for each
plot (only if non-faceted).}

\item{geom.colors}{user defined color for geoms. See 'Details' in \code{\link{sjp.grpfrq}}.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size, 
depending on plot type and function). Note that bar and bin widths mostly 
need smaller values than dot sizes.}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis 
labels are displayed in one line and when a line break is inserted.}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis, 
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{show.values}{logical, whether values should be plotted or not.}

\item{digits}{numeric, amount of digits after decimal point when rounding estimates and values.}

\item{y.offset}{numeric, offset for text labels when their alignment is adjusted 
to the top/bottom of the geom (see \code{hjust} and \code{vjust}).}

\item{show.p}{logical, adds significance levels to values, or value and 
variable labels.}

\item{show.summary}{logical, if \code{TRUE} (default), a summary with chi-squared 
statistics (see \code{\link{chisq.test}}), Cramer's V or Phi-value etc. 
is shown. If a cell contains expected values lower than five (or lower than 10 
if df is 1), the Fisher's excact test (see \code{\link{fisher.test}}) is 
computed instead of chi-squared test. If the table's matrix is larger 
than 2x2, Fisher's excact test with Monte Carlo simulation is computed.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot One-Way-Anova table sum of squares (SS) of each factor level (group) 
               against the dependent variable. The SS of the factor variable against the 
               dependent variable (variance within and between groups) is printed to
               the model summary.
}
\examples{
library(sjmisc)
data(efc)
# note: "var.grp" does not need to be a factor.
# coercion to factor is done by the function
sjp.aov1(efc$c12hour, efc$e42dep)


}
\seealso{
\code{\link{sjt.grpmean}}
}

