/*
 * Decompiled with CFR 0.152.
 */
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;

public class SJDBCResultSetUtilities {
    private static final int SPLUS_32BIT_NA = 2146435073;
    private static final long SPLUS_64BIT_NA = 0x7FFFFFFF7FFFFFFFL;
    private static final int R_INTEGER_NA = Integer.MIN_VALUE;
    private static final double R_NUMERIC_NA = Double.longBitsToDouble(9218868437227407266L);
    private static final double R_NUMERIC_NAN = Double.NaN;
    private static final Hashtable<String, ResultSet> g_rsTable = new Hashtable();
    private static final Hashtable<String, Object[]> g_dataTable = new Hashtable();
    private static int g_defaultNumRows = 100;

    private static boolean is64Bit() {
        return System.getProperty("os.arch").indexOf("64") != -1 || System.getProperty("sun.arch.data.model").indexOf("64") != -1;
    }

    private SJDBCResultSetUtilities() {
    }

    public static void register(String string, ResultSet resultSet) {
        g_rsTable.put(string, resultSet);
    }

    public static void unregister(String string) {
        g_rsTable.remove(string);
    }

    public static void setDefaultNumberOfRows(int n) {
        g_defaultNumRows = n;
    }

    public static int getDefaultNumberOfRows() {
        return g_defaultNumRows;
    }

    public static Object[] getData(String string) throws SQLException {
        return SJDBCResultSetUtilities.getData(string, true, -1);
    }

    public static Object[] getData(String string, boolean bl, int n) throws SQLException {
        int n2;
        int n3;
        int n4;
        boolean bl2 = SJDBCResultSetUtilities.is64Bit();
        ResultSet resultSet = g_rsTable.get(string);
        if (resultSet == null) {
            return null;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n5 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n5];
        String[] stringArray2 = new String[n5];
        int[] nArray = new int[n5];
        Object[] objectArray = new Object[n5];
        int[] nArray2 = new int[n5];
        int n6 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            stringArray[n4] = resultSetMetaData.getColumnName(n4 + 1);
            stringArray2[n4] = resultSetMetaData.getColumnTypeName(n4 + 1);
            nArray[n4] = resultSetMetaData.getColumnType(n4 + 1);
            switch (nArray[n4]) {
                case -5: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    n6 = 8;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    n6 = 91;
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    n6 = 4;
                    break;
                }
                case -7: 
                case 16: {
                    n6 = -7;
                    break;
                }
                default: {
                    n6 = 1111;
                }
            }
            nArray2[n4] = n6;
        }
        n4 = g_defaultNumRows;
        if (bl) {
            n3 = 0;
            try {
                resultSet.getType();
            }
            catch (Error error) {
                n3 = 1;
            }
            if (n3 == 0 && resultSet.getType() != 1003) {
                resultSet.last();
                n4 = resultSet.getRow();
                resultSet.beforeFirst();
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            objectArray[n3] = SJDBCResultSetUtilities.newArrayOfType(nArray2[n3], n4);
        }
        String string2 = "";
        for (n3 = 0; (n < 0 || n3 < n) && resultSet.next(); ++n3) {
            if (n3 == n4) {
                n4 = 2 * n4;
                for (n2 = 0; n2 < n5; ++n2) {
                    objectArray[n2] = SJDBCResultSetUtilities.newArrayOfType(nArray2[n2], n4, objectArray[n2]);
                }
            }
            block18: for (n2 = 0; n2 < n5; ++n2) {
                switch (nArray2[n2]) {
                    case 8: {
                        ((double[])objectArray[n2])[n3] = resultSet.getDouble(n2 + 1);
                        if (!resultSet.wasNull()) continue block18;
                        ((double[])objectArray[n2])[n3] = R_NUMERIC_NA;
                        continue block18;
                    }
                    case 91: {
                        Timestamp timestamp = resultSet.getTimestamp(n2 + 1);
                        if (timestamp != null) {
                            ((String[])objectArray[n2])[n3] = timestamp.toString();
                            continue block18;
                        }
                        ((String[])objectArray[n2])[n3] = null;
                        continue block18;
                    }
                    case 4: {
                        ((int[])objectArray[n2])[n3] = resultSet.getInt(n2 + 1);
                        if (!resultSet.wasNull()) continue block18;
                        ((int[])objectArray[n2])[n3] = Integer.MIN_VALUE;
                        continue block18;
                    }
                    case -7: {
                        ((boolean[])objectArray[n2])[n3] = resultSet.getBoolean(n2 + 1);
                        continue block18;
                    }
                    default: {
                        ((String[])objectArray[n2])[n3] = string2 = resultSet.getString(n2 + 1);
                    }
                }
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            objectArray[n2] = SJDBCResultSetUtilities.newArrayOfType(nArray2[n2], n3, objectArray[n2]);
        }
        Object[] objectArray2 = new Object[]{stringArray, stringArray2, nArray2, objectArray};
        return objectArray2;
    }

    private static Object newArrayOfType(int n, int n2) {
        return SJDBCResultSetUtilities.newArrayOfType(n, n2, null);
    }

    private static Object newArrayOfType(int n, int n2, Object object) {
        Object[] objectArray = null;
        switch (n) {
            case 8: {
                double[] dArray = new double[n2];
                if (object != null) {
                    double[] dArray2 = (double[])object;
                    for (int i = 0; i < Math.min(dArray2.length, n2); ++i) {
                        dArray[i] = dArray2[i];
                    }
                }
                objectArray = dArray;
                break;
            }
            case 4: {
                int[] nArray = new int[n2];
                if (object != null) {
                    int[] nArray2 = (int[])object;
                    for (int i = 0; i < Math.min(nArray2.length, n2); ++i) {
                        nArray[i] = nArray2[i];
                    }
                }
                objectArray = nArray;
                break;
            }
            case -7: {
                boolean[] blArray = new boolean[n2];
                if (object != null) {
                    boolean[] blArray2 = (boolean[])object;
                    for (int i = 0; i < Math.min(blArray2.length, n2); ++i) {
                        blArray[i] = blArray2[i];
                    }
                }
                objectArray = blArray;
                break;
            }
            default: {
                String[] stringArray = new String[n2];
                if (object != null) {
                    String[] stringArray2 = (String[])object;
                    for (int i = 0; i < Math.min(stringArray2.length, n2); ++i) {
                        stringArray[i] = stringArray2[i];
                    }
                }
                objectArray = stringArray;
            }
        }
        return objectArray;
    }

    public static void snextPopulateData(String string, boolean bl, int n) throws SQLException {
        g_dataTable.put(string, SJDBCResultSetUtilities.getData(string, bl, n));
    }

    public static void snextReleaseData(String string) {
        g_dataTable.remove(string);
    }

    public static String[] snextGetColNames(String string) {
        Object[] objectArray = g_dataTable.get(string);
        return (String[])objectArray[0];
    }

    public static int[] snextGetColTypeCodes(String string) {
        Object[] objectArray = g_dataTable.get(string);
        return (int[])objectArray[2];
    }

    public static String[] snextGetStringColumn(String string, int n) {
        Object[] objectArray = g_dataTable.get(string);
        return (String[])((Object[])objectArray[3])[n];
    }

    public static int[] snextGetIntegerColumn(String string, int n) {
        Object[] objectArray = g_dataTable.get(string);
        return (int[])((Object[])objectArray[3])[n];
    }

    public static boolean[] snextGetBooleanColumn(String string, int n) {
        Object[] objectArray = g_dataTable.get(string);
        return (boolean[])((Object[])objectArray[3])[n];
    }

    public static double[] snextGetDoubleColumn(String string, int n) {
        Object[] objectArray = g_dataTable.get(string);
        return (double[])((Object[])objectArray[3])[n];
    }
}

