% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_vars.R
\name{pred_vars}
\alias{pred_vars}
\alias{resp_val}
\alias{resp_var}
\title{Get predictor and response variables from models}
\usage{
pred_vars(x)

resp_var(x)

resp_val(x)
}
\arguments{
\item{x}{A fitted model.}
}
\value{
The name(s) of the response or predictor variables from \code{x}
          as character vector; or the values from \code{x}'s response vector.
}
\description{
\code{pred_vars()} and \code{resp_var()} return the names of a
               model's predictor or response variables as character vector.
               \cr \cr
               \code{resp_val()} returns the values of the model's response
               vector.
}
\examples{
data(efc)
fit <- lm(neg_c_7 ~ e42dep + c161sex, data = efc)

pred_vars(fit)
resp_var(fit)

resp_val(fit)

}

