% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_akt}
\alias{read_akt}
\title{Read AKT kin output file}
\usage{
read_akt(file)
}
\arguments{
\item{file}{Input file path}
}
\value{
A tibble containing the 7 columns from the akt file.
}
\description{
Reads in an \verb{akt kin} \href{https://illumina.github.io/akt/#kin}{results file}. Input \code{file} must have seven columns, whitespace delimited:
\enumerate{
\item id1 (member 1)
\item id2 (member 2)
\item IBD0 (ratio of IBD0/All SNPS)
\item IBD1 (ratio of IBD1/All SNPS)
\item Kinship Coefficient
\item NSNPS
}
}
\examples{
aktFile <- system.file("extdata", "3gens.akt", package="skater", mustWork=TRUE)
akt <- read_akt(aktFile)
akt

}
