% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/szroeter.R
\name{szroeter}
\alias{szroeter}
\title{Szroeter's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
szroeter(mainlm, deflator = NA, h = SKH, qfmethod = "imhof", statonly = FALSE)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{deflator}{Either a character specifying a column name from the
design matrix of \code{mainlm} or an integer giving the index of a
column of the design matrix. This variable is suspected to be
related to the error variance under the alternative hypothesis.
\code{deflator} may not correspond to a column of 1's (intercept).
Default \code{NA} means the data will be left in its current order
(e.g. in case the existing index is believed to be associated with
error variance).}

\item{h}{A non-decreasing function taking as its argument the index
\code{i} of observations from 1 to \eqn{n}. Defaults to \code{SKH},
which is equivalent to \eqn{h(i)=2(1-\cos \frac{\pi i}{n+1})}.
The function must be able to take a vector argument of length \code{n}.}

\item{qfmethod}{A character, either \code{"imhof"}, \code{"davies"}, or
\code{"integrate"}, corresponding to the \code{algorithm} argument
of \code{\link[skedastic]{pRQF}}. The default is \code{"imhof"}.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the method of
   \insertCite{Szroeter78;textual}{skedastic} for testing for
   heteroskedasticity in a linear regression model.
}
\details{
The test entails putting the data rows in increasing order of
   some specified deflator (e.g., one of the explanatory variables) that
   is believed to be related to the error variance by some non-decreasing
   function. The test statistic is a ratio of quadratic forms in the OLS
   residuals. It is a right-tailed test.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
szroeter(mtcars_lm, deflator = "qsec")

}
\references{
{\insertAllCited{}}
}
