% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbyla.R
\name{verbyla}
\alias{verbyla}
\title{Verbyla's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
verbyla(mainlm, auxdesign = NA, statonly = FALSE)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{auxdesign}{A \code{\link[base]{data.frame}} or
\code{\link[base]{matrix}} representing an auxiliary design matrix of
containing exogenous variables that (under alternative hypothesis) are
related to error variance, or a character "fitted.values" indicating
that the fitted \eqn{\hat{y}_i} values from OLS should be used.
If set to \code{NA} (the default), the
design matrix of the original regression model is used. An intercept
is included in the auxiliary regression even if the first column of
\code{auxdesign} is not a vector of ones.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the residual maximum likelihood test of
   \insertCite{Verbyla93;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
Verbyla's Test entails fitting a generalised auxiliary regression model
in which the response variable is the vector of standardised squared
residuals \eqn{e_i^2/\hat{\sigma}^2} from the original OLS
model and the design matrix is some function of \eqn{Z}, an
\eqn{n \times q} matrix consisting of \eqn{q} exogenous variables, appended
to a column of ones.
The test statistic is half the residual sum of squares from this generalised
auxiliary regression. Under the null hypothesis of homoskedasticity, the
distribution of the test statistic is asymptotically chi-squared with
\eqn{q} degrees of freedom. The test is right-tailed.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
verbyla(mtcars_lm)
verbyla(mtcars_lm, auxdesign = "fitted.values")

}
\references{
{\insertAllCited{}}
}
