% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rms.init.landscape.R
\name{rms.init.landscape}
\alias{rms.init.landscape}
\title{Initialize a landscape object}
\usage{
rms.init.landscape(num.pops = NULL, carrying = NULL, sample.size = NULL,
  mig.rates = NULL, num.loc = NULL, loc.type = NULL, mut.rate = NULL,
  seq.length = NULL, num.stgs = NULL, selfing = NULL, surv.matr = NULL,
  repr.matr = NULL, male.matr = NULL, init.pop.sizes = NULL,
  num.gen = NULL, num.alleles = NULL, allele.freqs = NULL)
}
\arguments{
\item{num.pops}{number of populations to simulate}

\item{carrying}{maximum population sizes for each population}

\item{sample.size}{size of sample to be pulled from each population}

\item{mig.rates}{a list of among-population migration matrices}

\item{num.loc}{number of independently segregating loci}

\item{loc.type}{sequence or microsatellite}

\item{mut.rate}{per gene mutation rate}

\item{seq.length}{if simulating a sequence, the length of the molecule}

\item{num.stgs}{number of demographic stages in a population}

\item{selfing}{selfing rate (must range from 0 [random mating] to 1 [complete selfing]}

\item{surv.matr}{within pop survival matrices}

\item{repr.matr}{within pop reproduction matrices}

\item{male.matr}{with pop male repro matrices}

\item{init.pop.sizes}{starting population sizes}

\item{num.gen}{number of generations to simulate}

\item{num.alleles}{vector of the number of alleles per locus}

\item{allele.freqs}{list of allele freqs for each locus (range 0-1)}
}
\description{
Initialize a landscape object
}

