% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{liSim}
\alias{liSim}
\title{Simulate user tracked menstrual cycle data for an individual using the li model.}
\usage{
liSim(i, skipProb, maxCycles, trueBetas, trueGammas = NULL)
}
\arguments{
\item{i}{Individual identifier. Character, numeric or integer.}

\item{skipProb}{Vector, ignored for this model.}

\item{maxCycles}{Integer, Maximum possible number of true cycles per tracked cycle.}

\item{trueBetas}{Optional. True values for generated mean regression coefficients.}

\item{trueGammas}{NULL, left for consistency. Will throw error if specified.}
}
\value{
\describe{
\item{'Individual'}{Individual identifiers.}
\item{'TrackedCycles'}{Tracked cycles.}
\item{'NumTrue'}{Number of true values.}
\item{'SkipProb'}{Individual's probability of skipping tracking a cycle}
\item{'Mean'}{Individual's mean values.}
\item{'Beta0'}{Beta0 true value.}
\item{'Gamma0}{NA}
\item{'Z0'}{1}
\item{'X0',...,'XN'}{Covariate matrix for Mean, where N is the length of trueBetas.}
}
}
\description{
This function generates synthetic data for user tracked menstrual cycles for a
single individual using the li model. For this model Beta0 = log(30), and Gamma0 doesn't really make sense.
}
\seealso{
\code{\link{skipTrack.simulate}}
}
