% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skm_cpp_rd.r
\name{skm_sgl_cpp}
\alias{skm_sgl_cpp}
\title{skm_sgl_cpp}
\usage{
skm_sgl_cpp(x, s_init, s_must, max_it)
}
\arguments{
\item{x}{an m x n matrix often m < n, as a convention index rows of x with s, and
cols of x with t so x(i, j) can be expressed as (s_i, t_j) equally.}

\item{s_init}{an init vector of k index to start the search of optimal index set of k,
length of s_init also defined the number of index want to be select.}

\item{s_must}{an index vector set should be selected before selecting other index.}

\item{max_it}{max number of iterations can run for optimizing result.
max number of iterations within a single initial run on optimal path.}
}
\value{
skmSolution
}
\description{
solve skm with single and a fixed given s_init
}
\details{
a numeric m x n matrix x often m << n and want to select a subset of k from
 m such that it minimize the sum(min(x(i, j) - minimum w.r.t each j over all
 i within selected index set), over all i)

 if m == n and x(i, j) as euclidean distance then it is equivalent to kmeans

 skm can select a combined set for deploying resource, for example, where to
 build 5 warehouses on united states, which often different than build these
 warehouses via select the current best one by one.
}
\seealso{
Other skm: \code{\link{skm_mlp_cpp}},
  \code{\link{skm_mls_cpp}}, \code{\link{skm_rgi_cpp}},
  \code{\link{skm_rgs_cpp}}
}

