% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotAz}
\alias{plotAz}
\title{Polar plot of orientations (azimuths)}
\usage{
plotAz(az, obj, loc, obj.label = T, ...)
}
\arguments{
\item{az}{Array of azimuths or data frame with column named \emph{True.Azimuth}. Values
outside the [0, 360] range will be ignored.}

\item{obj}{(Optional) A \emph{skyscapeR.object} object created with \code{\link{sky.objects}}
for displaying the azimuths of celestial objects. Beware that this assumes a single
location (given by parameter loc) and a flat horizon of zero degrees.}

\item{loc}{(Optional) This can be either the latitude of the
location, or a \emph{skyscapeR.horizon} object. Only necessary for plotting potential
celestial targets.}

\item{obj.label}{(Optional) Boolean to control whether to label the celestial objects in
the polar plot. Defaults to \emph{TRUE}.}

\item{...}{Any other parameters to be passed unto \code{\link[plotrix]{polar.plot}}}
}
\description{
This function creates a polar plot of azimuthal data. It is a wrapper for
\code{\link[plotrix]{polar.plot}}
}
\examples{
# Plot some azimuth data:
az <- c(120, 100, 93, 97, 88, 115, 112, 67)
plotAz(az)

# To visualize this data against the common solar and lunar targets:
tt <- sky.objects(c('sun','moon'), epoch=-2000, lty=c(2,3))
plotAz(az, tt, loc=c(35,-8))
}
\seealso{
\code{\link[plotrix]{polar.plot}}, \code{\link{sky.objects}}
}
