% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{dev.slackr}
\alias{dev.slackr}
\title{Send the graphics contents of the current device to a \code{slack.com} channel}
\usage{
dev.slackr(channels = Sys.getenv("SLACK_CHANNEL"), ...,
  api_token = Sys.getenv("SLACK_API_TOKEN"))
}
\arguments{
\item{channels}{list of channels to post image to}

\item{...}{other arguments passed into png device}

\item{api_token}{the slack.com full API token (chr)}
}
\value{
\code{httr} response object from \code{POST} call
}
\description{
\code{dev.slackr} sends the graphics contents of the current device to the specified \code{slack.com} channel.
This requires setting up a full API token (i.e. not a webhook & not OAuth) for this to work.
}
\examples{
\dontrun{
slackrSetup()

# ggplot
library(ggplot2)
qplot(mpg, wt, data=mtcars)
dev.slackr("#results")

# base
barplot(VADeaths)
dev.slackr("@jayjacobs")
}
}
\seealso{
\code{\link{slackrSetup}}, \code{\link{save.slackr}}, \code{\link{slackrUpload}}
}

