% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{slackrSetup}
\alias{slackrSetup}
\title{Setup environment variables for \code{slack.com} API}
\usage{
slackrSetup(channel = "#general", username = "slackr", icon_emoji = "",
  token = "", incoming_webhook_url = "", api_token = "",
  config_file = "~/.slackr", echo = FALSE)
}
\arguments{
\item{channel}{default channel to send the output to (chr) defaults to \code{#general}}

\item{username}{the username output will appear from (chr) defaults to \code{slackr}}

\item{icon_emoji}{which emoji picture to use (chr) defaults to none (can be left blank in config file as well)}

\item{token}{the \url{slack.com} webhook API token string (chr) defaults to none}

\item{incoming_webhook_url}{the slack.com URL prefix to use (chr) defaults to none}

\item{api_token}{the slack.com full API token (chr)}

\item{config_file}{a configuration file (DCF) - see \link{read.dcf} - format with the config values.}

\item{echo}{display the configuraiton variables (bool) initially \code{FALSE}}
}
\description{
Initialize all the environment variables \link{slackr} will need to use to
work properly.
}
\details{
By default, \code{slackr} (and other functions) will use the \code{#general} room and a username
of \code{slackr()} with no emoji and the default \url{slack.com} API prefix URL. You
still need to provide the webhook API token in \code{token} for anyting to work.
Failure to call this function before calling \code{slackr()} will result in a
message to do so.

If a valid file is found at the locaiton pointed to by \code{config_file}, the
values there will be used. The fields should be specified as such in the file: \cr
\cr
\code{ token: yourTokenCode} \cr
\code{ channel: #general} \cr
\code{ username: slackr} \cr
\code{ icon_emoji:} \cr
\code{ incoming_webhook_url: https://yourgroup.slack.com/services/hooks/incoming-webhook?} \cr \cr
}
\note{
You need a \url{slack.com} account and will also need to setup an incoming webhook and full API tokens: \url{https://api.slack.com/}
}
\examples{
\dontrun{
# reads from default file
slackrSetup()

# reads from alternate config
slackrSetup(config_file="/path/to/my/slackrconfig)

# the hard way
slackrSetup(channel="#code", token="mytoken",
            url_prefix="http://myslack.slack.com/services/hooks/incoming-webhook?")
}
}
\seealso{
\code{\link{slackr}}, \code{\link{dev.slackr}}, \code{\link{save.slackr}}, \code{\link{slackrUpload}}
}

