% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_csv.R
\name{slackr_csv}
\alias{slackr_csv}
\title{Send a data frame to Slack as a CSV}
\usage{
slackr_csv(
  data,
  filename = tempfile(fileext = ".csv"),
  title = basename(filename),
  initial_comment = basename(filename),
  channels = Sys.getenv("SLACK_CHANNEL"),
  bot_user_oauth_token = Sys.getenv("SLACK_BOT_USER_OAUTH_TOKEN"),
  ...
)
}
\arguments{
\item{data}{the data frame to upload}

\item{filename}{the file to save to. Defaults to a tempfile. Using the default is \emph{highly} advised, as using a non-tempfile will write a file that persists on the disk (either in the working directory, or at the location specified)}

\item{title}{title on Slack (optional - defaults to filename)}

\item{initial_comment}{comment for file on slack (optional - defaults to filename)}

\item{channels}{Slack channels to save to (optional)}

\item{bot_user_oauth_token}{Slack bot user OAuth token}

\item{...}{additional arguments to be passed to \code{write.csv()}}
}
\value{
\code{httr} response object from \code{POST} call (invisibly)

\code{httr} response object from \code{POST} call (invisibly)
}
\description{
\code{slackr_csv} simplifies the process of sending a data frame to Slack as a CSV file.
It is highly recommended to leave the \code{filename} argument as the default (tempfile), as changing it will persist a csv file in your working directory.
}
\seealso{
\code{\link[=slackr_upload]{slackr_upload()}}
}
\author{
Matt Kaye (aut)
}
