% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_bot.r
\name{slackr_bot}
\alias{slackr_bot}
\title{Send result of R expressions to a Slack channel via webhook API}
\usage{
slackr_bot(
  ...,
  incoming_webhook_url = Sys.getenv("SLACK_INCOMING_WEBHOOK_URL")
)
}
\arguments{
\item{...}{expressions to be sent to Slack.}

\item{incoming_webhook_url}{which \code{slack.com} API endpoint URL to use
(see section \strong{Webhook URLs} for details).}
}
\description{
Takes an \code{expr}, evaluates it and sends the output to a Slack
chat destination via the webhook API. Useful for logging, messaging on long
compute tasks or general information sharing.
}
\details{
By default, everything but \code{expr} will be looked for in a "\code{SLACK_}"
environment variable. You can override or just specify these values directly
instead, but it's probably better to call \code{\link[=slackr_setup]{slackr_setup()}} first.
}
\note{
You need a \url{https://www.slack.com} account and will also need to
setup an incoming webhook: \url{https://api.slack.com/}. Old style webhooks are
no longer supported.
}
\section{Webhook URLs}{
 Webhook URLs look like: \itemize{

\item \verb{https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX}

}

OLD STYLE WEBHOOKS ARE NO LONGER SUPPORTED
}

\examples{
\dontrun{
slackr_setup()
slackr_bot("iris info", head(iris), str(iris))

# or directly
slackr_bot(
  "Test message",
  incoming_webhook_url = "https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX"
)
}
}
\seealso{
\code{\link[=slackr_setup]{slackr_setup()}}, \code{\link[=slackr]{slackr()}},
\code{\link[=slackr_dev]{slackr_dev()}}, \code{\link[=slackr_save]{slackr_save()}},
\code{\link[=slackr_upload]{slackr_upload()}}
}
