% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_user_leagues.R
\name{get_user_leagues}
\alias{get_user_leagues}
\title{Gather Leagues for User}
\usage{
get_user_leagues(
  user_id,
  sport = "nfl",
  season = substr(Sys.Date(), start = 1, stop = 4)
)
}
\arguments{
\item{user_id}{User ID generated by Sleeper (numeric or character)}

\item{sport}{Sport for league information (character)}

\item{season}{Season for league information (numeric or character)}
}
\value{
Returns a data frame containing information about the user.
}
\description{
Given a user ID and optional sport and season, grab the league data concerning that particular user. 
This includes total rosters, scoring settings, roster positions, and more.
}
\examples{
\dontrun{get_user_leagues(688556535013502976)}
\dontrun{get_user_leagues("688556535013502976", sport = "nfl", season = "2021")}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, September 2021
}
\keyword{league}
\keyword{user}
