% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide2.R, R/pslide.R
\name{slide2}
\alias{slide2}
\alias{slide2_vec}
\alias{slide2_dbl}
\alias{slide2_int}
\alias{slide2_lgl}
\alias{slide2_chr}
\alias{slide2_dfr}
\alias{slide2_dfc}
\alias{pslide}
\alias{pslide_vec}
\alias{pslide_dbl}
\alias{pslide_int}
\alias{pslide_lgl}
\alias{pslide_chr}
\alias{pslide_dfr}
\alias{pslide_dfc}
\title{Slide over multiple inputs simultaneously}
\usage{
slide2(
  .x,
  .y,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE
)

slide2_vec(
  .x,
  .y,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE,
  .ptype = NULL
)

slide2_dbl(
  .x,
  .y,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE
)

slide2_int(
  .x,
  .y,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE
)

slide2_lgl(
  .x,
  .y,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE
)

slide2_chr(
  .x,
  .y,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE
)

slide2_dfr(
  .x,
  .y,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE,
  .names_to = rlang::zap(),
  .name_repair = c("unique", "universal", "check_unique")
)

slide2_dfc(
  .x,
  .y,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE,
  .size = NULL,
  .name_repair = c("unique", "universal", "check_unique", "minimal")
)

pslide(.l, .f, ..., .before = 0L, .after = 0L, .step = 1L, .complete = FALSE)

pslide_vec(
  .l,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE,
  .ptype = NULL
)

pslide_dbl(
  .l,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE
)

pslide_int(
  .l,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE
)

pslide_lgl(
  .l,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE
)

pslide_chr(
  .l,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE
)

pslide_dfr(
  .l,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE,
  .names_to = rlang::zap(),
  .name_repair = c("unique", "universal", "check_unique")
)

pslide_dfc(
  .l,
  .f,
  ...,
  .before = 0L,
  .after = 0L,
  .step = 1L,
  .complete = FALSE,
  .size = NULL,
  .name_repair = c("unique", "universal", "check_unique", "minimal")
)
}
\arguments{
\item{.x, .y}{\verb{[vector]}

Vectors to iterate over. Vectors of size 1 will be recycled.}

\item{.f}{\verb{[function / formula]}

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.before, .after}{\verb{[integer(1) / Inf]}

The number of values before or after the current element to
include in the sliding window. Set to \code{Inf} to select all elements
before or after the current element. Negative values are allowed, which
allows you to "look forward" from the current element if used as the
\code{.before} value, or "look backwards" if used as \code{.after}.}

\item{.step}{\verb{[positive integer(1)]}

The number of elements to shift the window forward between function calls.}

\item{.complete}{\verb{[logical(1)]}

Should \code{.f} be evaluated on complete windows only? If \code{FALSE},
the default, then partial computations will be allowed.}

\item{.ptype}{\verb{[vector(0) / NULL]}

A prototype corresponding to the type of the output.

If \code{NULL}, the default, the output type is determined by computing the
common type across the results of the calls to \code{.f}.

If supplied, the result of each call to \code{.f} will be cast to that type,
and the final output will have that type.

If \code{getOption("vctrs.no_guessing")} is \code{TRUE}, the \code{.ptype} must be
supplied. This is a way to make production code demand fixed types.}

\item{.names_to}{This controls what to do with input names supplied in \code{...}.
\itemize{
\item By default, input names are \link[rlang:zap]{zapped}.
\item If a string, specifies a column where the input names will be
copied. These names are often useful to identify rows with
their original input. If a column name is supplied and \code{...} is
not named, an integer column is used instead.
\item If \code{NULL}, the input names are used as row names.
}}

\item{.name_repair}{One of \code{"unique"}, \code{"universal"}, or
\code{"check_unique"}. See \code{\link[vctrs:vec_as_names]{vec_as_names()}} for the meaning of these
options.

With \code{vec_rbind()}, the repair function is applied to all inputs
separately. This is because \code{vec_rbind()} needs to align their
columns before binding the rows, and thus needs all inputs to
have unique names. On the other hand, \code{vec_cbind()} applies the
repair function after all inputs have been concatenated together
in a final data frame. Hence \code{vec_cbind()} allows the more
permissive minimal names repair.}

\item{.size}{If, \code{NULL}, the default, will determine the number of
rows in \code{vec_cbind()} output by using the standard recycling rules.

Alternatively, specify the desired number of rows, and any inputs
of length 1 will be recycled appropriately.}

\item{.l}{\verb{[list]}

A list of vectors. The length of \code{.l} determines the
number of arguments that \code{.f} will be called with. If \code{.l} has names,
they will be used as named arguments to \code{.f}. Elements of \code{.l} with size
1 will be recycled.}
}
\value{
A vector fulfilling the following invariants:

\subsection{\code{slide2()}}{
\itemize{
\item \code{vec_size(slide2(.x, .y)) == vec_size_common(.x, .y)}
\item \code{vec_ptype(slide2(.x, .y)) == list()}
}

}

\subsection{\code{slide2_vec()} and \verb{slide2_*()} variants}{
\itemize{
\item \code{vec_size(slide2_vec(.x, .y)) == vec_size_common(.x, .y)}
\item \code{vec_size(slide2_vec(.x, .y)[[1]]) == 1L}
\item \code{vec_ptype(slide2_vec(.x, .y, .ptype = ptype)) == ptype}
}

}

\subsection{\code{pslide()}}{
\itemize{
\item \code{vec_size(pslide(.l)) == vec_size_common(!!! .l)}
\item \code{vec_ptype(pslide(.l)) == list()}
}

}

\subsection{\code{pslide_vec()} and \verb{pslide_*()} variants}{
\itemize{
\item \code{vec_size(pslide_vec(.l)) == vec_size_common(!!! .l)}
\item \code{vec_size(pslide_vec(.l)[[1]]) == 1L}
\item \code{vec_ptype(pslide_vec(.l, .ptype = ptype)) == ptype}
}

}
}
\description{
These are variants of \code{\link[=slide]{slide()}} that iterate over multiple inputs in
parallel. They are parallel in the sense that each input is processed in
parallel with the others, not in the sense of multicore computing. These
functions work similarly to \code{map2()} and \code{pmap()} from purrr.
}
\examples{
# Slide along two inputs at once
slide2(1:4, 5:8, ~list(.x, .y), .before = 2)

# Or, for more than two, use `pslide()`
pslide(list(1:4, 5:8, 9:12), ~list(.x, .y, ..3), .before = 2)

# You can even slide along the rows of multiple data frames of
# equal size at once
set.seed(16)
x <- data.frame(a = rnorm(5), b = rnorm(5))
y <- data.frame(c = letters[1:5], d = letters[6:10])

row_return <- function(x_rows, y_rows) {
  if (sum(x_rows$a) < 0) {
    x_rows
  } else {
    y_rows
  }
}

slide2(x, y, row_return, .before = 1, .after = 2)

}
\seealso{
\code{\link[=slide]{slide()}}, \code{\link[=slide_index2]{slide_index2()}}, \code{\link[=hop_index2]{hop_index2()}}
}
