% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{nn}
\alias{nn}
\title{Determine nearest neighbors}
\usage{
nn(d, k, method = "c", self = FALSE)
}
\arguments{
\item{d}{A square distance matrix for the 
coordinates of interest.}

\item{k}{The number of neighbors to return (if 
\code{method = "c"}) or the distance for which 
observations are considered neighbors (if \code{method 
= "d"}).}

\item{method}{The method of determining the neighbors. 
The default is \code{"c"}, specifying that the \code{k}
nearest neighbors (the number of neighbors) for each 
observation should be returned.  The alternative is 
\code{"d"}, meaning that neighbors are determined by 
their distance from an observation.  In that case, two 
observations are neighbors if their separation distance
is less or equal to \code{k}.}

\item{self}{A logical indicating whether an observation 
is a neighbor with itself.  The default is 
\code{FALSE}.}
}
\value{
Returns a list with the nearest neighbors of each
  observation. For each element of the list, the indices
  order neighbors from nearest to farthest.
}
\description{
\code{nn} determines the nearest neighbors for a set of 
observations based on a distance matrix.
}
\details{
This function determine nearest neighbors in two ways: 1.
number of neighbors or 2. distance.

If \code{method = "c"}, then \code{k} specifies the total
number of neighbors to return for each observation.

If \code{method = "d"}, then \code{k} specifies the maximum
distance for which an observation is considered a 
neighbor.

The function returns the neighbors for each 
observation.
}
\examples{
data(grave)
# make distance matrix
d = as.matrix(dist(cbind(grave$x, grave$y)))
# 3 nearest neighbors
nnc = nn(d, k = 3, method = "c")
# nearest neighbors within k units of each observation
nnd = nn(d, k = 200, method = "d")
}
\author{
Joshua French
}
