% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord3D.R
\name{allspan3D}
\alias{allspan3D}
\title{Plot Span and Vectors in 3D}
\usage{
allspan3D(M, V = NULL, th = c(-90, -45, 0, 45, 90, 135), V2 = NULL, col = NULL)
}
\arguments{
\item{M}{Matrix for which the span should be shown.}

\item{V}{Either NULL, a vector of length 3, or a matrix with each column a
vector of length 3.}

\item{th}{A vector indicating the horizontal angle at which the plot should
be shown.}

\item{V2}{A matrix or vector of the same dimensions as M indicating the
starting points of the vectors in M (default is the origin for all).}

\item{col}{Vector colors; if entered, must have a value for each vector.}
}
\value{
No return value, called for side effects
}
\description{
Plot the span of a matrix plus any vectors in a 3D plot at one or more
angles. A plot is produced for each entry of \code{th}.
}
\examples{
M=matrix(c(1,2,4,3,0,2),3)
oldpar <- par(mfrow=c(3,2))
allspan3D(M,cbind(M,M[,1]-M[,2]),V2=matrix(c(rep(0,6),M[,2]),3),col=c(2,2,1))
par(oldpar)
}
