% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_mrh.R
\name{fitStateMRH}
\alias{fitStateMRH}
\alias{fitViterbiMRH}
\alias{fitPartialViterbiMRH}
\title{Estimation of states at each time point with Moving-Resting-Handling Process}
\usage{
fitStateMRH(data, theta, integrControl = integr.control())

fitViterbiMRH(data, theta, integrControl = integr.control())

fitPartialViterbiMRH(data, theta, startpoint, pathlength,
  integrControl = integr.control())
}
\arguments{
\item{data}{a \code{data.frame} whose first column is the observation
time, and other columns are location coordinates.}

\item{theta}{the parameters for Moving-Resting-Handling model, in the
order of rate of moving, rate of resting, rate of handling, volatility
and switching probability.}

\item{integrControl}{Integration control vector includes rel.tol,
abs.tol, and subdivisions.}

\item{startpoint}{Start time point of interested time interval.}

\item{pathlength}{the length of interested time interval.}
}
\value{
A \code{data.frame} contains estimated results, with elements:
\itemize{
 \item original data be estimated.
 \item conditional probability of moving, resting, handling (\code{p.m},
\code{p.r}, \code{p.h}), which is \eqn{Pr(S(t = t_k) = s_k | X)} for
\code{fitStateMRH}; \eqn{log-Pr(s_0, ..., s_k | X_k)} for
\code{fitViterbiMRH}, where \eqn{X_k} is \eqn{(X_0, ..., X_k)};
and \eqn{log-Pr(s_k, ..., s_{k+q-1}|X)} for \code{fitPartialViterbiMRH}.
 \item estimated states with 0-moving, 1-resting, 2-handling.
}
}
\description{
Estimate the state at each time point under the Moving-Resting-Handling
process with Embedded Brownian Motion with animal movement data at
discretely time points. See the difference between \code{fitStateMRH}
and \code{fitViterbiMRH} in detail part. Using \code{fitPartialViterbiMRH}
to estimate the state during a small piece of time interval.
}
\details{
\code{fitStateMRH} estimates the most likely state by maximizing
the probability of \eqn{Pr(S(t = t_k) = s_k | X)}, where X is the whole
data and \eqn{s_k} is the possible sates at \eqn{t_k} (moving, resting
or handling).

\code{fitViterbiMRH} estimates the most likely state path by maximizing
\eqn{Pr(S(t = t_0) = s_0, S(t = t_1) = s_1, ..., S(t = t_n) = s_n | X)}, where
X is the whole data and \eqn{s_0, s_1, ..., s_n} is the possible
state path.

\code{fitPartialViterbiMRH} estimates the most likely state path of
a small peice of time interval, by maximizing the probability of
\eqn{Pr(S(t = t_k) = s_k, ..., S(t = t_{k+q-1}) = s_{k+q-1} | X)},
where \eqn{k} is the start time point and \eqn{q} is the length of interested
time interval.
}
\examples{
\donttest{
set.seed(06269)
tgrid <- seq(0, 400, by = 8)
dat <- rMRH(tgrid, 4, 0.5, 0.1, 5, 0.8, 'm')
fitStateMRH(dat, c(4, 0.5, 0.1, 5, 0.8))
fitViterbiMRH(dat, c(4, 0.5, 0.1, 5, 0.8))
fitPartialViterbiMRH(dat, c(4, 0.5, 0.1, 5, 0.8), 20, 10)
}

}
\references{
Pozdnyakov, V., Elbroch, L.M., Hu, C., Meyer, T., and Yan, J. (2018+)
On estimation for Brownian motion governed by telegraph process with
multiple off states. <arXiv:1806.00849>
}
\seealso{
\code{\link{rMRH}} for simulation.
\code{\link{fitMRH}} for estimation of parameters.
}
\author{
Chaoran Hu
}
