% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_smap.R
\name{list_smap}
\alias{list_smap}
\title{Lists the contents of SMAP data files}
\usage{
list_smap(files, all = FALSE)
}
\arguments{
\item{files}{A \code{data.frame} produced by \code{download_smap()} that
specifies input data files.}

\item{all}{If TRUE a longer, more detailed list of information on each
entry is provided.}
}
\value{
Returns a list of \code{data.frame} objects that list the contents
of each data file in \code{files}.
}
\description{
This function returns a list of the contents of SMAP data files.
}
\examples{
\dontrun{
files <- find_smap(id = "SPL4SMGP", dates = "2015-03-31", version = 2)
files <- download_smap(files[1, ])
list_smap(files)
list_smap(files, all = TRUE)
}
}
