% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{smdocker_config}
\alias{smdocker_config}
\title{Set \code{paws} \code{config} across \code{smdocker} package}
\usage{
smdocker_config(
  aws_access_key_id = NULL,
  aws_secret_access_key = NULL,
  aws_session_token = NULL,
  region_name = NULL,
  profile_name = NULL,
  disable_ssl = FALSE,
  anonymous = FALSE,
  refresh = FALSE,
  ...
)
}
\arguments{
\item{aws_access_key_id}{(character): AWS access key ID}

\item{aws_secret_access_key}{(character): AWS secret access key}

\item{aws_session_token}{(character): AWS temporary session token}

\item{region_name}{(character): Default region when creating new connections}

\item{profile_name}{(character): The name of a profile to use. If not given,
then the default profile is used.}

\item{disable_ssl}{(logical): Whether or not to use \code{SSL}. By default, \code{SSL} is used.}

\item{anonymous}{(logical): Set up anonymous credentials when connecting to \code{AWS}.}

\item{refresh}{(logical): Refresh cached smdocker \code{config}}

\item{...}{Other parameters within \code{paws} client.}
}
\value{
Invisible list, containing credentials for \code{paws} clients.
}
\description{
This function sets up \code{paws} client config list for all \code{AWS} calls.
This function only needs to be used when changing default settings when
connecting to \code{AWS}.
}
\examples{
# Set up connection using profile
smdocker_config(profile_name = "smdocker_example")

# Reset connection to connect to a different region
smdocker_config(
  profile_name = "smdocker_example",
  region_name = "us-east-1",
  refresh = TRUE
)
}
\seealso{
\link[paws.compute]{ecr} \link[paws.developer.tools]{codebuild}
\link[paws.machine.learning]{sagemaker} \link[paws.management]{cloudwatchlogs}
\link[paws.security.identity]{iam} \link[paws.security.identity]{sts}
\link[paws.storage]{s3}
}
