% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlf.zones.R
\name{mlf.zones}
\alias{mlf.zones}
\title{Determine the candidate zone using the maxima likelihood first algorithm of Yao et al. (2011).}
\usage{
mlf.zones(coords, cases, pop, w, ex = sum(cases)/sum(pop) * pop,
  ubpop = 0.5, ubd = 1, lonlat = FALSE, parallel = TRUE,
  type = "pruned")
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid coordinates for the regions.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each region.}

\item{w}{A binary spatial adjacency matrix.}

\item{ex}{The expected number of cases for each region.  The default is calculated under the constant risk hypothesis.}

\item{ubpop}{The upperbound of the proportion of the total population to consider for a cluster.}

\item{ubd}{The upperbound for the radius of a cluster.  This should be a proportion in (0, 1].  The value is the proportion of the maximum intercentroid distance between any two locations in \code{coords}. See Details.}

\item{lonlat}{The default is \code{FALSE}, which specifies that Euclidean distance should be used.If \code{lonlat} is \code{TRUE}, then the great circle distance is used to calculate the intercentroid distance.}

\item{parallel}{A logical indicating whether the test should be parallelized using the \code{parallel::mclapply function}.  Default is \code{TRUE}.  If \code{TRUE}, no progress will be reported.}

\item{type}{One of \code{"maxonly"}, \code{"pruned"}, or \code{"all"}. Specifying \code{"maxonly"} returns only the maximum test statistic across all candidate zones, \code{"pruned"} returns information for the zone with the largest test statistic, while \code{"all"} returns information for all candidate zones.  Default is \code{"pruned"}.}
}
\value{
Returns a list that includes the location id of the zone and the associated test statistic, counts, expected counts, and population in the zone.  If \code{type = "all"}, then each of these elements is a list or vector corresponding to each respective candidate zone.
}
\description{
\code{mlf.zones} determines the most likely cluster zone obtained by implementing the maxima likelihood first scann method of Yao et al. (2011).  Note that this is really just a special case of the dynamic minimum spanning tree (SMST) algorithm of Assuncao et al. (2006)
}
\details{
Each step of the mlf scan test seeks to maximize the likelihood ratio test statistic used in the original spatial scan test (Kulldorff 1997).  The first zone considered is the region that maximizes this likelihood ration test statistic, providing that no more than \code{ubpop} proportion of the total population is in the zone.  The second zone is the first zone and the connected region that maximizes the scan statistic, subject to the population and distance constraints.  This pattern continues until no additional zones can be added due to population or distance constraints.

Every zone considered must have a total population less than \code{ubpop * sum(pop)} in the study area.  Additionally, the maximum intercentroid distance for the regions within a zone must be no more than \code{ubd * the maximum intercentroid distance across all regions}.
}
\examples{
data(nydf)
data(nyw)
coords = as.matrix(nydf[,c("x", "y")])
mlf.zones(coords, cases = floor(nydf$cases), pop = nydf$pop, w = nyw, lonlat = TRUE)
}
\references{
Yao, Z., Tang, J., & Zhan, F. B. (2011). Detection of arbitrarily-shaped clusters using a neighbor-expanding approach: A case study on murine typhus in South Texas. International journal of health geographics, 10(1), 1.

Assuncao, R.M., Costa, M.A., Tavares, A. and Neto, S.J.F. (2006). Fast detection of arbitrarily shaped disease clusters, Statistics in Medicine, 25, 723-742.
}
\author{
Joshua French
}
